/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.misc;

import java.util.function.Supplier;

public class MemoizingSupplier<T>
implements Supplier<T> {
    private final Supplier<T> delegate;
    volatile transient boolean initialized;
    transient T value;

    private MemoizingSupplier(Supplier<T> delegate) {
        this.delegate = delegate;
    }

    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        return new MemoizingSupplier<T>(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (!this.initialized) {
            MemoizingSupplier memoizingSupplier = this;
            synchronized (memoizingSupplier) {
                if (!this.initialized) {
                    T t = this.delegate.get();
                    this.value = t;
                    this.initialized = true;
                    return t;
                }
            }
        }
        return this.value;
    }
}

