/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import net.codestory.http.Cookie;
import net.codestory.http.Response;
import org.simpleframework.http.Status;

class SimpleResponse
implements Response {
    private final org.simpleframework.http.Response response;

    SimpleResponse(org.simpleframework.http.Response response) {
        this.response = response;
    }

    @Override
    public void close() throws IOException {
        this.response.close();
    }

    @Override
    public void commit() throws IOException {
        this.response.commit();
    }

    @Override
    public PrintStream printStream() throws IOException {
        return this.response.getPrintStream();
    }

    @Override
    public OutputStream outputStream() throws IOException {
        return this.response.getOutputStream();
    }

    @Override
    public void setContentLength(long length) {
        this.response.setContentLength(length);
    }

    @Override
    public void setValue(String name, String value) {
        this.response.setValue(name, value);
    }

    @Override
    public void setStatus(int statusCode) {
        this.response.setStatus(Status.getStatus((int)statusCode));
    }

    @Override
    public void setCookie(Cookie newCookie) {
        final CookieDate cookieDate = new CookieDate();
        org.simpleframework.http.Cookie cookie = new org.simpleframework.http.Cookie(newCookie.name(), newCookie.value(), newCookie.path(), newCookie.isNew()){

            public String toString() {
                return this.getName() + "=" + this.getValue() + "; version=" + this.getVersion() + (this.getPath() == null ? "" : "; path=" + this.getPath()) + (this.getDomain() == null ? "" : "; domain=" + this.getDomain()) + (this.getExpiry() < 0 ? "" : "; expires=" + cookieDate.format(this.getExpiry())) + (this.getExpiry() < 0 ? "" : "; max-age=" + this.getExpiry()) + (this.isSecure() ? "; secure" : "") + (this.isProtected() ? "; httponly" : "");
            }
        };
        cookie.setExpiry(newCookie.expiry());
        cookie.setVersion(newCookie.version());
        cookie.setSecure(newCookie.isSecure());
        cookie.setProtected(newCookie.isHttpOnly());
        cookie.setDomain(newCookie.domain());
        this.response.setCookie(cookie);
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return (T)(type.isInstance(this.response) ? this.response : null);
    }

    private static class CookieDate {
        private static final String FORMAT = "EEE, dd-MMM-yyyy HH:mm:ss z";
        private static final String ZONE = "GMT";
        private final DateFormat format = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
        private final TimeZone zone = new SimpleTimeZone(0, "GMT");

        public String format(int seconds) {
            Calendar calendar = Calendar.getInstance(this.zone, Locale.US);
            Date date = this.convert(seconds);
            calendar.setTime(date);
            this.format.setCalendar(calendar);
            return this.format.format(date);
        }

        private Date convert(int seconds) {
            long now = System.currentTimeMillis();
            long duration = (long)seconds * 1000L;
            long time = now + duration;
            return new Date(time);
        }
    }
}

