/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.transformers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.mule.providers.http.HttpResponse;
import org.mule.providers.http.ResponseWriter;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;

public class HttpResponseToString
extends AbstractTransformer {
    public HttpResponseToString() {
        this.registerSourceType(HttpResponse.class);
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            Header transferenc;
            ByteArrayOutputStream bos;
            HttpResponse response = (HttpResponse)src;
            ByteArrayOutputStream outstream = bos = new ByteArrayOutputStream(8192);
            ResponseWriter writer = new ResponseWriter((OutputStream)outstream, encoding);
            writer.println(response.getStatusLine());
            Iterator item = response.getHeaderIterator();
            while (item.hasNext()) {
                Header header = (Header)item.next();
                writer.print(header.toExternalForm());
            }
            writer.println();
            writer.flush();
            InputStream content = response.getBody();
            if (content != null && (transferenc = response.getFirstHeader("Transfer-Encoding")) != null) {
                response.removeHeaders("Content-Length");
                if (transferenc.getValue().indexOf("chunked") != -1) {
                    outstream = new ChunkedOutputStream((OutputStream)outstream);
                }
                IOUtils.copy((InputStream)content, (OutputStream)outstream);
                if (outstream instanceof ChunkedOutputStream) {
                    ((ChunkedOutputStream)outstream).finish();
                }
            }
            outstream.flush();
            bos.flush();
            byte[] result = bos.toByteArray();
            outstream.close();
            writer.close();
            bos.close();
            if (this.getReturnClass().equals(String.class)) {
                return new String(result, encoding);
            }
            return result;
        }
        catch (IOException e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }
}

