/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.BufferedWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class ResponseWriter
extends FilterWriter {
    public static final String CRLF = "\r\n";
    public static final String ISO_8859_1 = "ISO-8859-1";
    private OutputStream outStream = null;
    private String encoding = null;

    public ResponseWriter(OutputStream outStream) throws UnsupportedEncodingException {
        this(outStream, CRLF, ISO_8859_1);
    }

    public ResponseWriter(OutputStream outStream, String encoding) throws UnsupportedEncodingException {
        this(outStream, CRLF, encoding);
    }

    public ResponseWriter(OutputStream outStream, String lineSeparator, String encoding) throws UnsupportedEncodingException {
        super(new BufferedWriter(new OutputStreamWriter(outStream, encoding)));
        this.outStream = outStream;
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() throws IOException {
        if (this.outStream != null) {
            super.close();
            this.outStream = null;
        }
    }

    public void flush() throws IOException {
        if (this.outStream != null) {
            super.flush();
            this.outStream.flush();
        }
    }

    public void write(byte b) throws IOException {
        super.flush();
        this.outStream.write(b);
    }

    public void write(byte[] b) throws IOException {
        super.flush();
        this.outStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        super.flush();
        this.outStream.write(b, off, len);
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(int i) throws IOException {
        this.write(Integer.toString(i));
    }

    public void println(int i) throws IOException {
        this.write(Integer.toString(i));
        this.write(CRLF);
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.write(CRLF);
    }

    public void println() throws IOException {
        this.write(CRLF);
    }
}

