/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.ContentLengthInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HeaderGroup;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class HttpResponse {
    public static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";
    private HttpVersion ver = HttpVersion.HTTP_1_1;
    private int statuscode = 200;
    private String phrase = HttpStatus.getStatusText((int)200);
    private HeaderGroup headers = new HeaderGroup();
    private InputStream entity = null;
    private boolean keepAlive = false;
    private boolean disableKeepAlive = false;
    private String fallbackCharset = "ISO-8859-1";

    public HttpResponse() {
    }

    public HttpResponse(StatusLine statusline, Header[] headers, InputStream content) throws IOException {
        if (statusline == null) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        this.setStatusLine(HttpVersion.parse((String)statusline.getHttpVersion()), statusline.getStatusCode(), statusline.getReasonPhrase());
        this.setHeaders(headers);
        if (content != null) {
            long len;
            InputStream in = content;
            Header contentLength = this.headers.getFirstHeader("Content-Length");
            Header transferEncoding = this.headers.getFirstHeader("Transfer-Encoding");
            if (transferEncoding != null) {
                if (transferEncoding.getValue().indexOf("chunked") != -1) {
                    in = new ChunkedInputStream(in);
                }
            } else if (contentLength != null && (len = this.getContentLength()) >= 0L) {
                in = new ContentLengthInputStream(in, len);
            }
            this.entity = in;
        }
    }

    public void setStatusLine(HttpVersion ver, int statuscode, String phrase) {
        if (ver == null) {
            throw new IllegalArgumentException("HTTP version may not be null");
        }
        if (statuscode <= 0) {
            throw new IllegalArgumentException("Status code may not be negative or zero");
        }
        this.ver = ver;
        this.statuscode = statuscode;
        this.phrase = phrase != null ? phrase : HttpStatus.getStatusText((int)statuscode);
    }

    public void setStatusLine(HttpVersion ver, int statuscode) {
        this.setStatusLine(ver, statuscode, null);
    }

    public String getPhrase() {
        return this.phrase;
    }

    public int getStatuscode() {
        return this.statuscode;
    }

    public HttpVersion getHttpVersion() {
        return this.ver;
    }

    public String getStatusLine() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(this.ver);
        buffer.append(' ');
        buffer.append(this.statuscode);
        if (this.phrase != null) {
            buffer.append(' ');
            buffer.append(this.phrase);
        }
        return buffer.toString();
    }

    public boolean containsHeader(String name) {
        return this.headers.containsHeader(name);
    }

    public Header[] getHeaders() {
        return this.headers.getAllHeaders();
    }

    public Header getFirstHeader(String name) {
        return this.headers.getFirstHeader(name);
    }

    public void removeHeaders(String s) {
        if (s == null) {
            return;
        }
        Header[] headers = this.headers.getHeaders(s);
        for (int i = 0; i < headers.length; ++i) {
            this.headers.removeHeader(headers[i]);
        }
    }

    public void addHeader(Header header) {
        if (header == null) {
            return;
        }
        this.headers.addHeader(header);
    }

    public void setHeader(Header header) {
        if (header == null) {
            return;
        }
        this.removeHeaders(header.getName());
        this.addHeader(header);
    }

    public void setHeaders(Header[] headers) {
        if (headers == null) {
            return;
        }
        this.headers.setHeaders(headers);
    }

    public Iterator getHeaderIterator() {
        return this.headers.getIterator();
    }

    public String getCharset() {
        NameValuePair param;
        HeaderElement[] values;
        String charset = this.getFallbackCharset();
        Header contenttype = this.headers.getFirstHeader("Content-Type");
        if (contenttype != null && (values = contenttype.getElements()).length == 1 && (param = values[0].getParameterByName("charset")) != null) {
            charset = param.getValue();
        }
        return charset;
    }

    public long getContentLength() {
        Header contentLength = this.headers.getFirstHeader("Content-Length");
        if (contentLength != null) {
            try {
                return Long.parseLong(contentLength.getValue());
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -1L;
    }

    public void setBodyString(String string) {
        if (string != null) {
            byte[] raw = null;
            try {
                raw = string.getBytes(this.getCharset());
            }
            catch (UnsupportedEncodingException e) {
                raw = string.getBytes();
            }
            this.entity = new ByteArrayInputStream(raw);
            if (!this.containsHeader("Content-Type")) {
                this.setHeader(new Header("Content-Type", "text/plain"));
            }
            this.setHeader(new Header("Content-Length", Long.toString(raw.length)));
        } else {
            this.entity = null;
        }
    }

    public void setBody(InputStream instream) {
        this.entity = instream;
    }

    public InputStream getBody() {
        return this.entity;
    }

    public byte[] getBodyBytes() throws IOException {
        InputStream in = this.getBody();
        if (in != null) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(8192);
            IOUtils.copy((InputStream)in, (OutputStream)buffer);
            return buffer.toByteArray();
        }
        return null;
    }

    public String getBodyString() throws IOException {
        byte[] raw = this.getBodyBytes();
        if (raw != null) {
            return new String(raw, this.getCharset());
        }
        return null;
    }

    public boolean isKeepAlive() {
        return !this.disableKeepAlive && this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void disableKeepAlive(boolean keepalive) {
        this.disableKeepAlive = keepalive;
    }

    public String getFallbackCharset() {
        return this.fallbackCharset;
    }

    public void setFallbackCharset(String overrideCharset) {
        this.fallbackCharset = overrideCharset;
    }
}

