/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.resource.spi.work.Work;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.RequestContext;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.http.CookieHelper;
import org.mule.providers.http.HttpConnector;
import org.mule.providers.http.HttpRequest;
import org.mule.providers.http.HttpResponse;
import org.mule.providers.http.HttpServerConnection;
import org.mule.providers.http.RequestLine;
import org.mule.providers.streaming.StreamMessageAdapter;
import org.mule.providers.tcp.TcpMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.PropertiesHelper;

public class HttpMessageReceiver
extends TcpMessageReceiver {
    public HttpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
    }

    protected Work createWork(Socket socket) throws IOException {
        return new HttpWorker(socket);
    }

    public void doConnect() throws ConnectException {
        if (this.shouldConnect()) {
            super.doConnect();
        }
    }

    protected boolean shouldConnect() {
        StringBuffer requestUri = new StringBuffer();
        requestUri.append(this.endpoint.getProtocol()).append("://");
        requestUri.append(this.endpoint.getEndpointURI().getHost());
        requestUri.append(":").append(this.endpoint.getEndpointURI().getPort());
        requestUri.append("*");
        AbstractMessageReceiver[] temp = this.connector.getReceivers(requestUri.toString());
        for (int i = 0; i < temp.length; ++i) {
            AbstractMessageReceiver abstractMessageReceiver = temp[i];
            if (!abstractMessageReceiver.isConnected()) continue;
            return false;
        }
        return true;
    }

    protected String getRequestPath(UMOMessage message) {
        String path = (String)message.getProperty("http.request");
        int i = path.indexOf("?");
        if (i > -1) {
            path = path.substring(0, i);
        }
        return path;
    }

    protected AbstractMessageReceiver getTargetReceiver(UMOMessage message, UMOEndpoint endpoint) throws ConnectException {
        AbstractMessageReceiver receiver;
        String path = (String)message.getProperty("http.request");
        int i = path.indexOf("?");
        if (i > -1) {
            path = path.substring(0, i);
        }
        StringBuffer requestUri = new StringBuffer();
        requestUri.append(endpoint.getProtocol()).append("://");
        requestUri.append(endpoint.getEndpointURI().getHost());
        requestUri.append(":").append(endpoint.getEndpointURI().getPort());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Looking up receiver on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
        }
        if ((receiver = this.connector.getReceiver(requestUri.toString())) == null && !"/".equals(path)) {
            int x = path.lastIndexOf("/");
            if (x > 1 && path.indexOf(".") > x) {
                requestUri.append(path.substring(0, x));
            } else {
                requestUri.append(path);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Secondary lookup of receiver on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
            }
            if ((receiver = this.connector.getReceiver(requestUri.toString())) == null && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("No receiver found with secondary lookup on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
                this.logger.warn((Object)("Receivers on connector are: " + PropertiesHelper.propertiesToString((Map)this.connector.getReceivers(), (boolean)true)));
            }
        }
        return receiver;
    }

    private class HttpWorker
    implements Work {
        private HttpServerConnection conn = null;
        private String cookieSpec;
        private boolean enableCookies = false;

        public HttpWorker(Socket socket) throws IOException {
            this.conn = HttpMessageReceiver.this.endpoint.getEncoding() != null ? new HttpServerConnection(socket, HttpMessageReceiver.this.endpoint.getEncoding()) : new HttpServerConnection(socket);
            this.cookieSpec = MapUtils.getString((Map)HttpMessageReceiver.this.endpoint.getProperties(), (Object)"cookieSpec", (String)((HttpConnector)HttpMessageReceiver.this.connector).getCookieSpec());
            this.enableCookies = MapUtils.getBooleanValue((Map)HttpMessageReceiver.this.endpoint.getProperties(), (Object)"enableCookies", (boolean)((HttpConnector)HttpMessageReceiver.this.connector).isEnableCookies());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                do {
                    StreamMessageAdapter adapter;
                    this.conn.setKeepAlive(false);
                    HttpRequest request = this.conn.readRequest();
                    if (request == null) {
                        break;
                    }
                    HashMap<String, Object> headers = new HashMap<String, Object>();
                    Iterator rhi = request.getHeaderIterator();
                    while (rhi.hasNext()) {
                        Header header = (Header)rhi.next();
                        String headerName = header.getName();
                        Cookie[] headerValue = header.getValue();
                        if (headerName.startsWith("X-MULE")) {
                            headerName = headerName.substring(2);
                        } else if (headerName.equals("cookies")) {
                            Cookie[] cookies;
                            if (!this.enableCookies || (cookies = CookieHelper.parseCookies(header, this.cookieSpec)).length <= 0) continue;
                            headerValue = cookies;
                        }
                        headers.put(headerName, headerValue);
                    }
                    RequestLine reqLine = request.getRequestLine();
                    headers.put("http.method", reqLine.getMethod());
                    headers.put("http.request", reqLine.getUri());
                    headers.put("http.version", reqLine.getHttpVersion().toString());
                    headers.put("cookieSpec", this.cookieSpec);
                    Object body = null;
                    if (HttpMessageReceiver.this.endpoint.isStreaming() && request.getBody() != null) {
                        adapter = new StreamMessageAdapter(request.getBody(), this.conn.getOutputStream());
                        Iterator iterator = headers.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            adapter.setProperty((String)entry.getKey(), entry.getValue());
                        }
                    } else {
                        body = request.getBodyBytes();
                        if (body == null) {
                            body = reqLine.getUri();
                        }
                        adapter = HttpMessageReceiver.this.connector.getMessageAdapter((Object)new Object[]{body, headers});
                    }
                    MuleMessage message = new MuleMessage((Object)adapter);
                    if (HttpMessageReceiver.this.logger.isDebugEnabled()) {
                        HttpMessageReceiver.this.logger.debug(message.getProperty("http.request"));
                    }
                    AbstractMessageReceiver receiver = HttpMessageReceiver.this.getTargetReceiver((UMOMessage)message, HttpMessageReceiver.this.endpoint);
                    HttpResponse response = null;
                    if (receiver != null) {
                        UMOMessage returnMessage = receiver.routeMessage((UMOMessage)message, HttpMessageReceiver.this.endpoint.isSynchronous(), null);
                        Object tempResponse = returnMessage.getPayload();
                        response = tempResponse instanceof HttpResponse ? (HttpResponse)tempResponse : (HttpResponse)HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform(tempResponse);
                        response.disableKeepAlive(!((HttpConnector)HttpMessageReceiver.this.connector).isKeepAlive());
                    } else {
                        UMOEndpointURI uri = HttpMessageReceiver.this.endpoint.getEndpointURI();
                        String failedPath = uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort() + HttpMessageReceiver.this.getRequestPath((UMOMessage)message);
                        if (HttpMessageReceiver.this.logger.isDebugEnabled()) {
                            HttpMessageReceiver.this.logger.debug((Object)("Failed to bind to " + failedPath));
                        }
                        response = new HttpResponse();
                        response.setStatusLine(reqLine.getHttpVersion(), 404);
                        response.setBodyString(new Message(179, (Object)failedPath).toString());
                        RequestContext.setEvent((UMOEvent)new MuleEvent((UMOMessage)new MuleMessage((Object)response), (UMOImmutableEndpoint)HttpMessageReceiver.this.endpoint, (UMOSession)new MuleSession(HttpMessageReceiver.this.component), true));
                        response = (HttpResponse)HttpMessageReceiver.this.connector.getDefaultResponseTransformer().transform((Object)response);
                    }
                    this.conn.writeResponse(response);
                } while (this.conn.isKeepAlive());
            }
            catch (Exception e) {
                HttpMessageReceiver.this.handleException(e);
            }
            finally {
                this.conn.close();
                this.conn = null;
            }
        }

        public void release() {
            this.conn.close();
            this.conn = null;
        }
    }
}

