/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.transformers;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.providers.http.HttpConstants;
import org.mule.transformers.AbstractEventAwareTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.Utility;

public class UMOMessageToResponseString
extends AbstractEventAwareTransformer {
    private List headers = null;
    private SimpleDateFormat format = null;
    private String server = null;
    static /* synthetic */ Class class$java$lang$Object;

    public UMOMessageToResponseString() {
        this.registerSourceType(class$java$lang$Object == null ? (class$java$lang$Object = UMOMessageToResponseString.class$("java.lang.Object")) : class$java$lang$Object);
        this.setReturnClass(class$java$lang$Object == null ? (class$java$lang$Object = UMOMessageToResponseString.class$("java.lang.Object")) : class$java$lang$Object);
        this.headers = new ArrayList<String>(Arrays.asList(HttpConstants.RESPONSE_HEADER_NAMES));
        this.format = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz");
        this.server = MuleManager.getConfiguration().getProductName() + "/" + MuleManager.getConfiguration().getProductVersion();
    }

    public Object transform(Object src, UMOEventContext context) throws TransformerException {
        UMOMessage m;
        String user;
        int status = context.getIntProperty("http.status", 200);
        String version = (String)context.getProperty("http.version", (Object)"HTTP/1.1");
        String date = this.format.format(new Date());
        byte[] response = null;
        String contentType = (String)context.getProperty("Content-Type");
        if (src instanceof byte[]) {
            response = (byte[])src;
        } else if (contentType != null && contentType.startsWith("text/")) {
            response = src.toString().getBytes();
        } else {
            try {
                response = Utility.objectToByteArray((Object)src);
            }
            catch (IOException e) {
                throw new TransformerException(new Message(110, (Object)"Object", (Object)"byte[]"), (UMOTransformer)this, (Throwable)e);
            }
        }
        StringBuffer httpMessage = new StringBuffer();
        httpMessage.append(version).append(" ");
        httpMessage.append(status).append("\r\n");
        httpMessage.append("Date");
        httpMessage.append(": ").append(date).append("\r\n");
        httpMessage.append("Server");
        httpMessage.append(": ").append(this.server).append("\r\n");
        if (context.getProperty("Expires") == null) {
            httpMessage.append("Expires");
            httpMessage.append(": ").append(date).append("\r\n");
        }
        httpMessage.append("Content-Type");
        if (contentType == null) {
            httpMessage.append(": ").append("text/xml").append("\r\n");
        } else {
            httpMessage.append(": ").append(contentType).append("\r\n");
        }
        httpMessage.append("Content-Length");
        httpMessage.append(": ").append(response.length).append("\r\n");
        Iterator iterator = this.headers.iterator();
        while (iterator.hasNext()) {
            String headerName = (String)iterator.next();
            String value = (String)context.getProperty(headerName);
            if (value == null) continue;
            httpMessage.append(headerName).append(": ").append(value);
            httpMessage.append("\r\n");
        }
        Map customHeaders = (Map)context.getProperty("http.custom.headers");
        if (customHeaders != null) {
            Iterator iterator2 = customHeaders.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                httpMessage.append(entry.getKey()).append(": ").append(entry.getValue());
                httpMessage.append("\r\n");
            }
        }
        if ((user = (String)(m = context.getMessage()).getProperty((Object)"MULE_USER")) != null) {
            httpMessage.append("X-MULE_USER").append(": ").append(user);
            httpMessage.append("\r\n");
        }
        if (m.getCorrelationId() != null) {
            httpMessage.append("X-MULE_CORRELATION_ID").append(": ").append(m.getCorrelationId());
            httpMessage.append("\r\n");
            httpMessage.append("X-MULE_CORRELATION_GROUP").append(": ").append(m.getCorrelationGroupSize());
            httpMessage.append("\r\n");
            httpMessage.append("X-MULE_CORRELATION_SEQUENCE").append(": ").append(m.getCorrelationSequence());
            httpMessage.append("\r\n");
        }
        if (m.getReplyTo() != null) {
            httpMessage.append("X-MULE_REPLYTO").append(": ").append(m.getReplyTo().toString());
            httpMessage.append("\r\n");
        }
        httpMessage.append("\r\n");
        byte[] resultPayload = new byte[httpMessage.length() + response.length];
        System.arraycopy(httpMessage.toString().getBytes(), 0, resultPayload, 0, httpMessage.length());
        System.arraycopy(response, 0, resultPayload, httpMessage.length(), response.length);
        return resultPayload;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

