/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http.transformers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.mule.config.i18n.Message;
import org.mule.providers.http.HttpConstants;
import org.mule.transformers.AbstractEventAwareTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.Utility;

public class ObjectToHttpClientMethodRequest
extends AbstractEventAwareTransformer {
    private List requestHeaders = null;
    private List responseHeaders = null;
    static /* synthetic */ Class class$org$apache$commons$httpclient$HttpMethod;

    public ObjectToHttpClientMethodRequest() {
        this.setReturnClass(class$org$apache$commons$httpclient$HttpMethod == null ? (class$org$apache$commons$httpclient$HttpMethod = ObjectToHttpClientMethodRequest.class$("org.apache.commons.httpclient.HttpMethod")) : class$org$apache$commons$httpclient$HttpMethod);
        this.requestHeaders = new ArrayList<String>(Arrays.asList(HttpConstants.REQUEST_HEADER_NAMES));
        this.responseHeaders = new ArrayList<String>(Arrays.asList(HttpConstants.RESPONSE_HEADER_NAMES));
    }

    public Object transform(Object src, UMOEventContext context) throws TransformerException {
        String endpoint = (String)context.getProperty("MULE_ENDPOINT", null);
        if (endpoint == null) {
            throw new TransformerException(new Message(111, (Object)"MULE_ENDPOINT"), (UMOTransformer)this);
        }
        String method = (String)context.getProperty("http.method", (Object)"POST");
        try {
            URI uri = new URI(endpoint);
            GetMethod httpMethod = null;
            if ("GET".equals(method)) {
                httpMethod = new GetMethod(uri.toString());
                String paramName = (String)context.getProperty("http.get.body.param", (Object)"body");
                String query = uri.getQuery();
                query = query == null ? paramName + "=" + src.toString() : query + "&" + paramName + "=" + src.toString();
                httpMethod.setQueryString(query);
            } else {
                PostMethod postMethod = new PostMethod(uri.toString());
                String paramName = (String)context.getProperty("http.post.body.param");
                if (paramName == null) {
                    if (src instanceof String) {
                        postMethod.setRequestBody(src.toString());
                        postMethod.setRequestContentLength(src.toString().length());
                    } else {
                        byte[] buffer = Utility.objectToByteArray((Object)src);
                        postMethod.setRequestBody((InputStream)new ByteArrayInputStream(buffer));
                        postMethod.setRequestContentLength(buffer.length);
                    }
                } else {
                    postMethod.addParameter(paramName, src.toString());
                }
                httpMethod = postMethod;
            }
            Map p = context.getProperties();
            Iterator iterator = p.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry header = iterator.next();
                String headerName = header.getKey().toString();
                if (this.responseHeaders.contains(headerName) || !(header.getValue() instanceof String)) continue;
                if (headerName.startsWith("MULE_")) {
                    headerName = "X-" + headerName;
                }
                httpMethod.addRequestHeader(headerName, (String)header.getValue());
            }
            return httpMethod;
        }
        catch (Exception e) {
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

