/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Properties;
import javax.resource.spi.work.Work;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.impl.RequestContext;
import org.mule.impl.ResponseOutputStream;
import org.mule.providers.http.HttpConnector;
import org.mule.providers.tcp.TcpMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.monitor.Expirable;
import org.mule.util.monitor.ExpiryMonitor;

public class HttpMessageReceiver
extends TcpMessageReceiver {
    private ExpiryMonitor keepAliveMonitor;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Object;

    public HttpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        if (((HttpConnector)connector).isKeepAlive()) {
            this.keepAliveMonitor = new ExpiryMonitor(1000L);
        }
    }

    protected UMOTransformer getResponseTransformer() throws InitialisationException {
        UMOTransformer transformer = super.getResponseTransformer();
        if (transformer == null) {
            throw new InitialisationException(new Message("http", 1), (Object)this);
        }
        if (!(transformer.getReturnClass().equals(class$java$lang$String == null ? (class$java$lang$String = HttpMessageReceiver.class$("java.lang.String")) : class$java$lang$String) || transformer.getReturnClass().equals(array$B == null ? (array$B = HttpMessageReceiver.class$("[B")) : array$B) || transformer.getReturnClass().equals(class$java$lang$Object == null ? (class$java$lang$Object = HttpMessageReceiver.class$("java.lang.Object")) : class$java$lang$Object))) {
            throw new InitialisationException(new Message("http", 2, (Object)this.getConnector().getName()), (Object)this);
        }
        return transformer;
    }

    protected Work createWork(Socket socket) {
        return new HttpWorker(socket);
    }

    public void doDispose() {
        if (this.keepAliveMonitor != null) {
            this.keepAliveMonitor.dispose();
        }
        super.doDispose();
    }

    protected byte[] parseRequest(InputStream is, Properties p) throws IOException {
        byte[] payload;
        String line = null;
        try {
            line = HttpParser.readLine((InputStream)is);
        }
        catch (SocketException e) {
            return null;
        }
        catch (SocketTimeoutException e) {
            return null;
        }
        if (line == null) {
            return null;
        }
        int space1 = line.indexOf(" ");
        int space2 = line.indexOf(" ", space1 + 1);
        if (space1 == -1 || space2 == -1) {
            throw new IOException("Http message header line is malformed: " + line);
        }
        String method = line.substring(0, space1);
        String request = line.substring(space1 + 1, space2);
        String httpVersion = line.substring(space2 + 1);
        p.setProperty("http.method", method);
        p.setProperty("http.request", request);
        p.setProperty("http.version", httpVersion);
        Header[] headers = HttpParser.parseHeaders((InputStream)is);
        for (int i = 0; i < headers.length; ++i) {
            String name = headers[i].getName();
            if (name.startsWith("X-MULE_")) {
                name = name.substring(2);
            }
            p.setProperty(name, headers[i].getValue());
        }
        if (method.equals("GET")) {
            payload = request.getBytes();
        } else {
            boolean contentLengthNotSet = p.getProperty("Content-Length", null) == null;
            int contentLength = Integer.parseInt(p.getProperty("Content-Length", String.valueOf(32768)));
            byte[] buffer = new byte[contentLength];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int len = 0;
            int bytesWritten = 0;
            while (bytesWritten != contentLength) {
                len = is.read(buffer);
                if (len == -1) continue;
                baos.write(buffer, 0, len);
                bytesWritten += len;
                if (!contentLengthNotSet) continue;
                contentLength = bytesWritten;
            }
            payload = baos.toByteArray();
            baos.close();
        }
        return payload;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HttpWorker
    extends TcpMessageReceiver.TcpWorker
    implements Expirable {
        private boolean keepAlive = false;
        private boolean keepAliveRegistered = false;

        public HttpWorker(Socket socket) {
            super((TcpMessageReceiver)HttpMessageReceiver.this, socket);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int counter = 0;
                this.dataIn = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                this.dataOut = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                do {
                    String connection;
                    if (HttpMessageReceiver.this.isServerSide() && ++counter > 500) {
                        counter = 0;
                        Thread.yield();
                    }
                    if (HttpMessageReceiver.this.disposing.get() || this.socket.isClosed()) {
                        HttpMessageReceiver.this.logger.debug((Object)"Peer closed connection");
                        break;
                    }
                    Properties headers = new Properties();
                    byte[] payload = HttpMessageReceiver.this.parseRequest(this.dataIn, headers);
                    if (payload == null) {
                        break;
                    }
                    UMOMessageAdapter adapter = HttpMessageReceiver.this.connector.getMessageAdapter((Object)new Object[]{payload, headers});
                    boolean http11 = ((String)adapter.getProperty((Object)"http.version")).equalsIgnoreCase("HTTP/1.1");
                    this.keepAlive = !http11 ? adapter.getProperty((Object)"Keep-Alive") != null : (connection = (String)adapter.getProperty((Object)"Connection")) == null || !connection.equalsIgnoreCase("close");
                    if (this.keepAlive && !this.keepAliveRegistered) {
                        this.keepAliveRegistered = true;
                        if (HttpMessageReceiver.this.keepAliveMonitor != null) {
                            HttpMessageReceiver.this.keepAliveMonitor.addExpirable(((HttpConnector)HttpMessageReceiver.this.connector).getKeepAliveTimeout(), (Expirable)this);
                        } else {
                            HttpMessageReceiver.this.logger.info((Object)"Request has Keep alive set but the HttpConnector has keep alive disables");
                            this.keepAlive = false;
                        }
                    }
                    if (adapter == null) continue;
                    MuleMessage message = new MuleMessage(adapter);
                    if (HttpMessageReceiver.this.logger.isDebugEnabled()) {
                        HttpMessageReceiver.this.logger.debug((Object)((String)message.getProperty((Object)"http.request")));
                    }
                    ResponseOutputStream os = new ResponseOutputStream((OutputStream)this.dataOut, this.socket);
                    UMOMessage returnMessage = HttpMessageReceiver.this.routeMessage((UMOMessage)message, HttpMessageReceiver.this.endpoint.isSynchronous(), (OutputStream)os);
                    if (returnMessage == null) {
                        returnMessage = new MuleMessage((Object)"", null);
                    }
                    RequestContext.rewriteEvent((UMOMessage)returnMessage);
                    Object response = HttpMessageReceiver.this.responseTransformer.transform(returnMessage.getPayload());
                    if (response instanceof byte[]) {
                        this.dataOut.write((byte[])response);
                    } else {
                        this.dataOut.write(response.toString().getBytes());
                    }
                    this.dataOut.flush();
                    if (HttpMessageReceiver.this.keepAliveMonitor == null) continue;
                    HttpMessageReceiver.this.keepAliveMonitor.resetExpirable((Expirable)this);
                } while (!this.socket.isClosed() && this.keepAlive);
            }
            catch (Exception e) {
                this.keepAlive = false;
                HttpMessageReceiver.this.handleException(e);
            }
            finally {
                if (HttpMessageReceiver.this.keepAliveMonitor != null) {
                    HttpMessageReceiver.this.keepAliveMonitor.removeExpirable((Expirable)this);
                }
                this.dispose();
            }
        }

        public void expired() {
            HttpMessageReceiver.this.logger.debug((Object)"Keep alive timed out");
            this.dispose();
        }
    }
}

