/*
 * Decompiled with CFR 0.152.
 */
package me.melchor9000.net.resolver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import me.melchor9000.net.Callback;
import me.melchor9000.net.Future;
import me.melchor9000.net.FutureImpl;
import me.melchor9000.net.IOService;
import me.melchor9000.net.UDPSocket;
import me.melchor9000.net.resolver.DNSMessage;
import me.melchor9000.net.resolver.DNSQuery;
import me.melchor9000.net.resolver.DNSResolverCache;
import me.melchor9000.net.resolver.DNSResourceRecord;
import me.melchor9000.net.resolver.DNSUtils;

public class DNSResolver
implements AutoCloseable {
    private UDPSocket socket;
    private IOService service;

    public DNSResolver(IOService service) {
        this.socket = new UDPSocket(service);
        this.service = service;
    }

    public Future<Iterable<InetAddress>> resolveAsync(final String name) {
        final FutureImpl<Iterable<InetAddress>> future = new FutureImpl<Iterable<InetAddress>>(this.service, null);
        Iterable<InetAddress> resolved = DNSResolverCache.getAddresses(name);
        if (resolved != null) {
            future.postSuccess(resolved);
        } else {
            final DNSMessage message = new DNSMessage();
            final DNSMessage message4 = new DNSMessage();
            final int tid = message.getId();
            DNSQuery queryIPv4 = new DNSQuery();
            DNSQuery queryIPv6 = new DNSQuery();
            message.setRecursionDesired(true);
            message4.setRecursionDesired(true);
            queryIPv4.setName(name);
            queryIPv4.setType(DNSUtils.typeToInt("A"));
            queryIPv4.setClass(DNSUtils.classToInt("IN"));
            queryIPv6.setName(name);
            queryIPv6.setType(DNSUtils.typeToInt("AAAA"));
            queryIPv6.setClass(DNSUtils.classToInt("IN"));
            message.addQuery(queryIPv4);
            message.addQuery(queryIPv6);
            message4.addQuery(queryIPv4);
            message4.setId(tid);
            final Iterator<InetSocketAddress> dnsServers = DNSResolverCache.dnsServers().iterator();
            final InetSocketAddress[] currentServer = new InetSocketAddress[1];
            final boolean[] hasRepeatedRequestOnlyWithIPv4 = new boolean[1];
            Callback<Future<Void>> sendCbk = new Callback<Future<Void>>(){

                @Override
                public void call(Future<Void> arg) {
                    if (arg.isSuccessful()) {
                        final 1 self = this;
                        final DNSMessage message2 = new DNSMessage();
                        message2.setId(tid);
                        DNSResolver.this.socket.receiveAsyncFrom(message2).whenDone(new Callback<Future<UDPSocket.Packet>>(){

                            @Override
                            public void call(Future<UDPSocket.Packet> arg) {
                                if (arg.isSuccessful()) {
                                    if (message2.getOpcode() != 0) {
                                        if (dnsServers.hasNext()) {
                                            hasRepeatedRequestOnlyWithIPv4[0] = false;
                                            currentServer[0] = (InetSocketAddress)dnsServers.next();
                                            DNSResolver.this.socket.sendAsyncTo(message, currentServer[0]).whenDone(self);
                                        } else {
                                            future.postError(new UnknownHostException(name));
                                        }
                                    } else {
                                        DNSResolver.this.addAllRecords(name, message2.getAnswers());
                                        DNSResolver.this.addAllRecords(name, message2.getAuthorities());
                                        DNSResolver.this.addAllRecords(name, message2.getAdditionals());
                                        future.postSuccess(DNSResolverCache.getAddresses(name));
                                    }
                                } else if (!(arg.cause() instanceof CancellationException)) {
                                    future.postError(arg.cause());
                                } else if (hasRepeatedRequestOnlyWithIPv4[0]) {
                                    hasRepeatedRequestOnlyWithIPv4[0] = false;
                                    currentServer[0] = (InetSocketAddress)dnsServers.next();
                                    DNSResolver.this.socket.sendAsyncTo(message, currentServer[0]).whenDone(self);
                                } else {
                                    DNSResolver.this.socket.sendAsyncTo(message4, currentServer[0]).whenDone(self);
                                    hasRepeatedRequestOnlyWithIPv4[0] = true;
                                }
                            }
                        }).setTimeout(1000L);
                    } else {
                        future.postError(arg.cause());
                    }
                }
            };
            if (!this.socket.isOpen()) {
                this.socket.bind();
            }
            currentServer[0] = dnsServers.next();
            this.socket.sendAsyncTo(message, currentServer[0]).whenDone(sendCbk);
        }
        return future;
    }

    public Iterable<InetAddress> resolve(String name) {
        return this.resolveAsync(name).sync().getValueNow();
    }

    @Override
    public void close() {
        if (this.socket.isOpen()) {
            this.socket.close();
        }
    }

    public Future<Void> closeAsync() {
        return this.socket.closeAsync();
    }

    private void addAllRecords(String name, Iterable<DNSResourceRecord> a) {
        for (DNSResourceRecord record : a) {
            if (record.getTypeAsString().equals("A")) {
                DNSResolverCache.addAEntry(name, record);
                continue;
            }
            if (record.getTypeAsString().equals("CNAME")) {
                DNSResolverCache.addCNAMEEntry(name, record);
                continue;
            }
            if (!record.getTypeAsString().equals("AAAA")) continue;
            DNSResolverCache.addAAAAEntry(name, record);
        }
    }
}

