/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.pathfinding.astar;

import io.ytcode.pathfinding.astar.Grid;
import io.ytcode.pathfinding.astar.Point;

public class Reachability {
    public static boolean isReachable(int x1, int y1, int x2, int y2, Grid grid) {
        return Reachability.isReachable(x1, y1, x2, y2, 1, grid);
    }

    public static boolean isReachable(int x1, int y1, int x2, int y2, int scale, Grid grid) {
        return Reachability.getClosestWalkablePointToTarget(x1, y1, x2, y2, scale, grid) == Point.toPoint(x2, y2);
    }

    public static long getClosestWalkablePointToTarget(int x1, int y1, int x2, int y2, Grid grid) {
        return Reachability.getClosestWalkablePointToTarget(x1, y1, x2, y2, 1, grid);
    }

    public static long getClosestWalkablePointToTarget(int x1, int y1, int x2, int y2, int scale, Grid grid) {
        int gy0;
        int x0;
        double y0;
        int gy;
        int gx;
        double deltaY;
        double deltaX;
        if (scale < 1) {
            throw new IllegalArgumentException("Illegal scale: " + scale);
        }
        double cx1 = Reachability.scaleDown((double)x1 + 0.5, scale);
        double cy1 = Reachability.scaleDown((double)y1 + 0.5, scale);
        double cx2 = Reachability.scaleDown((double)x2 + 0.5, scale);
        double cy2 = Reachability.scaleDown((double)y2 + 0.5, scale);
        int gx1 = (int)cx1;
        int gy1 = (int)cy1;
        if (!grid.isWalkable(gx1, gy1)) {
            return Point.toPoint(x1, y1);
        }
        int gx2 = (int)cx2;
        int gy2 = (int)cy2;
        if (gx1 == gx2 && gy1 == gy2) {
            return Point.toPoint(x2, y2);
        }
        if (y1 == y2) {
            int inc = gx2 > gx1 ? 1 : -1;
            int gx3 = gx1 + inc;
            while (true) {
                if (!grid.isWalkable(gx3, gy1)) {
                    if (gx3 - inc == gx1) {
                        return Point.toPoint(x1, y1);
                    }
                    return Point.toPoint(Reachability.scaleUp(gx3 - inc, scale), y1);
                }
                if (gx3 == gx2) {
                    return Point.toPoint(x2, y2);
                }
                gx3 += inc;
            }
        }
        if (x1 == x2) {
            int inc = gy2 > gy1 ? 1 : -1;
            int gy3 = gy1 + inc;
            while (true) {
                if (!grid.isWalkable(gx1, gy3)) {
                    if (gy3 - inc == gy1) {
                        return Point.toPoint(x1, y1);
                    }
                    return Point.toPoint(x1, Reachability.scaleUp(gy3 - inc, scale));
                }
                if (gy3 == gy2) {
                    return Point.toPoint(x2, y2);
                }
                gy3 += inc;
            }
        }
        double dx = cx2 - cx1;
        double dy = cy2 - cy1;
        double k = dy / dx;
        double b = cy1 - k * cx1;
        if (Math.abs(dx) > Math.abs(dy)) {
            deltaX = dx > 0.0 ? 1.0 : -1.0;
            deltaY = deltaX * k;
        } else {
            deltaY = dy > 0.0 ? 1.0 : -1.0;
            deltaX = deltaY / k;
        }
        while (grid.isWalkable(gx = (int)(cx1 += deltaX), gy = (int)(cy1 += deltaY)) && (gx == gx1 || gy == gy1 || Math.rint(y0 = k * (double)(x0 = dx > 0.0 ? gx : gx1) + b) == y0 && !(k < 0.0) || !((gy0 = (int)y0) != gy ? !grid.isWalkable(gx, gy1) : !grid.isWalkable(gx1, gy)))) {
            if (gx == gx2 && gy == gy2) {
                return Point.toPoint(x2, y2);
            }
            gx1 = gx;
            gy1 = gy;
        }
        return Reachability.scaleUpPoint(cx1 - deltaX, cy1 - deltaY, scale);
    }

    private static double scaleDown(double d, int scale) {
        return d / (double)scale;
    }

    private static int scaleUp(int i, int scale) {
        return i * scale + scale / 2;
    }

    private static int scaleUp(double d, int scale) {
        return (int)(d * (double)scale);
    }

    private static long scaleUpPoint(int x, int y, int scale) {
        return Point.toPoint(Reachability.scaleUp(x, scale), Reachability.scaleUp(y, scale));
    }

    private static long scaleUpPoint(double x, double y, int scale) {
        return Point.toPoint(Reachability.scaleUp(x, scale), Reachability.scaleUp(y, scale));
    }
}

