/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.pathfinding.astar;

import io.ytcode.pathfinding.astar.TooLongPathException;
import io.ytcode.pathfinding.astar.Utils;

class Node {
    private static final int F_BITS = 16;
    private static final int F_MASK = Utils.mask(16);
    private static final int G_BITS = 16;
    private static final int G_MASK = Utils.mask(16);
    private static final int G_SHIFT = 16;
    private static final long G_F_MASK_COMPLEMENT = ((long)G_MASK << 16 | (long)F_MASK) ^ 0xFFFFFFFFFFFFFFFFL;
    private static final int Y_BITS = 16;
    static final int Y_MASK = Utils.mask(16);
    private static final int Y_SHIFT = 32;
    private static final int X_BITS = 16;
    static final int X_MASK = Utils.mask(16);
    private static final int X_SHIFT = 48;

    Node() {
    }

    static long toNode(int x, int y, int g, int f) {
        if (f < 0) {
            throw new TooLongPathException("TooBigF");
        }
        return (long)x << 48 | (long)y << 32 | (long)g << 16 | (long)f;
    }

    static int getX(long l) {
        return (int)(l >>> 48);
    }

    static int getY(long l) {
        return (int)(l >>> 32 & (long)Y_MASK);
    }

    static int getG(long l) {
        return (int)(l >> 16 & (long)G_MASK);
    }

    static int getF(long l) {
        return (int)(l & (long)F_MASK);
    }

    static long setGF(long l, int g, int f) {
        return l & G_F_MASK_COMPLEMENT | (long)g << 16 | (long)f;
    }
}

