/*
 * Decompiled with CFR 0.152.
 */
package io.ytcode.pathfinding.astar;

import io.ytcode.pathfinding.astar.Node;
import io.ytcode.pathfinding.astar.Utils;

public class Grid {
    private static final int NODE_BITS = 12;
    private static final int NODE_MASK;
    private static final int NODE_NULL = 0;
    private static final int NODE_CLOSED;
    private static final int NODE_PARENT_DIRECTION_BITS = 3;
    private static final int NODE_PARENT_DIRECTION_MASK;
    private static final int NODE_PARENT_DIRECTION_SHIFT = 12;
    private static final int NODE_PARENT_DIRECTION_SHIFT_MASK;
    private static final int WALKABLE_BITS = 1;
    private static final int WALKABLE_MASK;
    private static final int WALKABLE_SHIFT = 15;
    private static final int WALKABLE_SHIFT_MASK;
    static final int DIRECTION_UP = 0;
    static final int DIRECTION_DOWN = 1;
    static final int DIRECTION_LEFT = 2;
    static final int DIRECTION_RIGHT = 3;
    static final int DIRECTION_LEFT_UP = 4;
    static final int DIRECTION_LEFT_DOWN = 5;
    static final int DIRECTION_RIGHT_UP = 6;
    static final int DIRECTION_RIGHT_DOWN = 7;
    static final int MAX_OPEN_NODE_SIZE;
    private final short[][] grid;
    private final int width;
    private final int height;

    public Grid(int width, int height) {
        Utils.check(width > 0 && width <= Node.X_MASK + 1);
        Utils.check(height > 0 && height <= Node.Y_MASK + 1);
        this.grid = new short[width][height];
        this.width = width;
        this.height = height;
    }

    int info(int x, int y) {
        return this.grid[x][y] & (WALKABLE_SHIFT_MASK | NODE_MASK);
    }

    static boolean isUnwalkable(int info) {
        return (info & WALKABLE_SHIFT_MASK) != 0;
    }

    static boolean isNullNode(int info) {
        return info == 0;
    }

    static boolean isClosedNode(int info) {
        return info == NODE_CLOSED;
    }

    static int openNodeIdx(int info) {
        assert (info > 0 && info <= MAX_OPEN_NODE_SIZE);
        return info - 1;
    }

    void nodeClosed(int x, int y) {
        short[] sArray = this.grid[x];
        int n = y;
        sArray[n] = (short)(sArray[n] | NODE_CLOSED);
    }

    void openNodeIdxUpdate(int x, int y, int idx) {
        assert (idx >= 0 && idx < MAX_OPEN_NODE_SIZE);
        this.grid[x][y] = (short)(this.grid[x][y] & ~NODE_MASK | idx + 1);
    }

    void nodeParentDirectionUpdate(int x, int y, int d) {
        assert (d >= 0 && d <= NODE_PARENT_DIRECTION_MASK);
        this.grid[x][y] = (short)(this.grid[x][y] & ~NODE_PARENT_DIRECTION_SHIFT_MASK | d << 12);
    }

    int nodeParentDirection(int x, int y) {
        return this.grid[x][y] >>> 12 & NODE_PARENT_DIRECTION_MASK;
    }

    void clear() {
        for (int i = 0; i < this.width; ++i) {
            int j = 0;
            while (j < this.height) {
                short[] sArray = this.grid[i];
                int n = j++;
                sArray[n] = (short)(sArray[n] & WALKABLE_SHIFT_MASK);
            }
        }
    }

    boolean isClean() {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                if ((this.grid[i][j] & (NODE_PARENT_DIRECTION_SHIFT_MASK | NODE_MASK)) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public void setWalkable(int x, int y, boolean flag) {
        if (flag) {
            short[] sArray = this.grid[x];
            int n = y;
            sArray[n] = (short)(sArray[n] & ~WALKABLE_SHIFT_MASK);
        } else {
            short[] sArray = this.grid[x];
            int n = y;
            sArray[n] = (short)(sArray[n] | WALKABLE_SHIFT_MASK);
        }
    }

    public boolean isWalkable(int x, int y) {
        if (x < 0 || x >= this.width) {
            return false;
        }
        if (y < 0 || y >= this.height) {
            return false;
        }
        return (this.grid[x][y] & WALKABLE_SHIFT_MASK) == 0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    static {
        NODE_CLOSED = NODE_MASK = Utils.mask(12);
        NODE_PARENT_DIRECTION_MASK = Utils.mask(3);
        NODE_PARENT_DIRECTION_SHIFT_MASK = NODE_PARENT_DIRECTION_MASK << 12;
        WALKABLE_MASK = Utils.mask(1);
        WALKABLE_SHIFT_MASK = WALKABLE_MASK << 15;
        MAX_OPEN_NODE_SIZE = NODE_MASK - 1;
    }
}

