/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.xpipe.core.util.FailableFunction;
import io.xpipe.core.util.InPlaceSecretValue;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.function.Consumer;
import java.util.function.Function;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public interface SecretValue {
    public static char[] toBase64eChars(byte[] b) {
        byte[] base64 = Base64.getEncoder().encode(b);
        CharBuffer charBuf = ByteBuffer.wrap(base64).asCharBuffer();
        char[] arr = new char[charBuf.remaining()];
        charBuf.get(arr);
        return arr;
    }

    public static String toBase64e(byte[] b) {
        String base64 = Base64.getEncoder().encodeToString(b);
        return base64.replace("/", "-");
    }

    public static byte[] fromBase64e(String s) {
        return Base64.getDecoder().decode(s.replace("-", "/"));
    }

    public InPlaceSecretValue inPlace();

    default public void withSecretValue(Consumer<char[]> con) {
        char[] chars = this.getSecret();
        con.accept(chars);
        Arrays.fill(chars, '\u0000');
    }

    default public <T> T mapSecretValue(Function<char[], T> con) {
        char[] chars = this.getSecret();
        T r = con.apply(chars);
        Arrays.fill(chars, '\u0000');
        return r;
    }

    default public <T> T mapSecretValueFailable(FailableFunction<char[], T, Exception> con) throws Exception {
        char[] chars = this.getSecret();
        T r = con.apply(chars);
        Arrays.fill(chars, '\u0000');
        return r;
    }

    public byte[] getSecretRaw();

    public char[] getSecret();

    default public String getSecretValue() {
        return new String(this.getSecret());
    }
}

