/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.xpipe.core.util.JacksonExtension;
import io.xpipe.core.util.ModuleLayerLoader;
import io.xpipe.core.util.SecretValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;

public class JacksonMapper {
    private static final ObjectMapper BASE = new ObjectMapper();
    private static final ObjectMapper INSTANCE;
    private static boolean init;

    public static <T> T parse(String s, Class<T> c) throws JsonProcessingException {
        ObjectMapper mapper = JacksonMapper.getDefault();
        JsonNode tree = mapper.readTree(s);
        return (T)mapper.treeToValue((TreeNode)tree, c);
    }

    public static synchronized void configure(Consumer<ObjectMapper> mapper) {
        mapper.accept(INSTANCE);
    }

    private static List<Module> findModules(ModuleLayer layer) {
        ArrayList<Module> modules = new ArrayList<Module>();
        ServiceLoader<Module> loader = layer != null ? ServiceLoader.load(layer, Module.class) : ServiceLoader.load(Module.class);
        for (Module module : loader) {
            modules.add(module);
        }
        return modules;
    }

    private static List<JacksonExtension> findExtensions(ModuleLayer layer) {
        ArrayList<JacksonExtension> exts = new ArrayList<JacksonExtension>();
        ServiceLoader<JacksonExtension> loader = layer != null ? ServiceLoader.load(layer, JacksonExtension.class) : ServiceLoader.load(JacksonExtension.class);
        for (JacksonExtension module : loader) {
            exts.add(module);
        }
        return exts;
    }

    public static ObjectMapper newMapper() {
        if (!JacksonMapper.isInit()) {
            return BASE;
        }
        return INSTANCE.copy();
    }

    public static ObjectMapper getDefault() {
        if (!JacksonMapper.isInit()) {
            return BASE;
        }
        return INSTANCE;
    }

    public static ObjectMapper getCensored() {
        if (!JacksonMapper.isInit()) {
            return BASE;
        }
        ObjectMapper c = INSTANCE.copy();
        c.registerModule((Module)new SimpleModule(){

            public void setupModule(Module.SetupContext context) {
                this.addSerializer(SecretValue.class, (JsonSerializer)new JsonSerializer<SecretValue>(this){

                    public void serialize(SecretValue value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                        gen.writeString("<secret>");
                    }

                    public void serializeWithType(SecretValue value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
                        gen.writeString("<secret>");
                    }
                });
                super.setupModule(context);
            }
        });
        return c;
    }

    public static boolean isInit() {
        return init;
    }

    static {
        init = false;
        ObjectMapper objectMapper = BASE;
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.setVisibility(objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE));
        INSTANCE = BASE.copy();
    }

    public static class Loader
    implements ModuleLayerLoader {
        @Override
        public void init(ModuleLayer layer) {
            List<Module> modules = JacksonMapper.findModules(layer);
            INSTANCE.registerModules(modules);
            List<JacksonExtension> extensions = JacksonMapper.findExtensions(layer);
            for (JacksonExtension extension : extensions) {
                SimpleModule mod = new SimpleModule();
                if (extension instanceof JsonSerializer) {
                    JsonSerializer s = (JsonSerializer)extension;
                    this.add(mod, extension.getType(), s);
                }
                if (extension instanceof JsonDeserializer) {
                    JsonDeserializer d = (JsonDeserializer)extension;
                    this.add(mod, extension.getType(), d);
                }
                INSTANCE.registerModule((Module)mod);
            }
            init = true;
        }

        private <T> void add(SimpleModule mod, Class<?> c, JsonSerializer<?> s) {
            mod.addSerializer(c, s);
        }

        private <T> void add(SimpleModule mod, Class<?> c, JsonDeserializer<?> s) {
            mod.addDeserializer(c, s);
        }
    }
}

