/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import io.xpipe.core.dialog.BaseQueryElement;
import io.xpipe.core.dialog.BusyElement;
import io.xpipe.core.dialog.ChoiceElement;
import io.xpipe.core.dialog.HeaderElement;
import io.xpipe.core.process.OsType;
import io.xpipe.core.process.ShellDialect;
import io.xpipe.core.process.ShellDialects;
import io.xpipe.core.process.ShellScript;
import io.xpipe.core.store.FilePath;
import io.xpipe.core.store.StorePath;
import io.xpipe.core.util.InPlaceSecretValue;
import io.xpipe.core.util.JacksonMapper;
import io.xpipe.core.util.NewLine;
import io.xpipe.core.util.StreamCharset;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;

public class CoreJacksonModule
extends SimpleModule {
    public void setupModule(Module.SetupContext context) {
        context.registerSubtypes(new NamedType[]{new NamedType(InPlaceSecretValue.class), new NamedType(BaseQueryElement.class), new NamedType(ChoiceElement.class), new NamedType(BusyElement.class), new NamedType(HeaderElement.class)});
        for (ShellDialect t : ShellDialects.ALL) {
            context.registerSubtypes(new NamedType[]{new NamedType(t.getClass())});
        }
        this.addSerializer(FilePath.class, new FilePathSerializer());
        this.addDeserializer(FilePath.class, new FilePathDeserializer());
        this.addSerializer(StorePath.class, new StorePathSerializer());
        this.addDeserializer(StorePath.class, new StorePathDeserializer());
        this.addSerializer(Charset.class, new CharsetSerializer());
        this.addDeserializer(Charset.class, new CharsetDeserializer());
        this.addSerializer(ShellDialect.class, new ShellDialectSerializer());
        this.addDeserializer(ShellDialect.class, new ShellDialectDeserializer());
        this.addSerializer(StreamCharset.class, new StreamCharsetSerializer());
        this.addDeserializer(StreamCharset.class, new StreamCharsetDeserializer());
        this.addSerializer(NewLine.class, new NewLineSerializer());
        this.addDeserializer(NewLine.class, new NewLineDeserializer());
        this.addSerializer(Path.class, new LocalPathSerializer());
        this.addDeserializer(Path.class, new LocalPathDeserializer());
        this.addSerializer(OsType.class, new OsTypeSerializer());
        this.addDeserializer(OsType.Local.class, new OsTypeLocalDeserializer());
        this.addDeserializer(OsType.Any.class, new OsTypeAnyDeserializer());
        this.addSerializer(ShellScript.class, new ShellScriptSerializer());
        this.addDeserializer(ShellScript.class, new ShellScriptDeserializer());
        context.setMixInAnnotations(Throwable.class, ThrowableTypeMixIn.class);
        context.addSerializers((Serializers)this._serializers);
        context.addDeserializers((Deserializers)this._deserializers);
    }

    public static class FilePathSerializer
    extends JsonSerializer<FilePath> {
        public void serialize(FilePath value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.toString());
        }
    }

    public static class FilePathDeserializer
    extends JsonDeserializer<FilePath> {
        public FilePath deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new FilePath(p.getValueAsString());
        }
    }

    public static class StorePathSerializer
    extends JsonSerializer<StorePath> {
        public void serialize(StorePath value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            String[] ar = (String[])value.getNames().toArray(String[]::new);
            jgen.writeArray(ar, 0, ar.length);
        }
    }

    public static class StorePathDeserializer
    extends JsonDeserializer<StorePath> {
        public StorePath deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            CollectionLikeType javaType = JacksonMapper.getDefault().getTypeFactory().constructCollectionLikeType(List.class, String.class);
            List list = (List)JacksonMapper.getDefault().readValue(p, (JavaType)javaType);
            return new StorePath(list);
        }
    }

    public static class CharsetSerializer
    extends JsonSerializer<Charset> {
        public void serialize(Charset value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.name());
        }
    }

    public static class CharsetDeserializer
    extends JsonDeserializer<Charset> {
        public Charset deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Charset.forName(p.getValueAsString());
        }
    }

    public static class ShellDialectSerializer
    extends JsonSerializer<ShellDialect> {
        public void serialize(ShellDialect value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.getId());
        }
    }

    public static class ShellDialectDeserializer
    extends JsonDeserializer<ShellDialect> {
        public ShellDialect deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode tree = (JsonNode)JacksonMapper.getDefault().readTree(p);
            if (tree.isObject()) {
                JsonNode t = tree.get("type");
                if (t == null) {
                    return null;
                }
                return ShellDialects.byNameIfPresent(t.asText()).orElse(null);
            }
            return ShellDialects.byNameIfPresent(tree.asText()).orElse(null);
        }
    }

    public static class StreamCharsetSerializer
    extends JsonSerializer<StreamCharset> {
        public void serialize(StreamCharset value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.toString());
        }
    }

    public static class StreamCharsetDeserializer
    extends JsonDeserializer<StreamCharset> {
        public StreamCharset deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return StreamCharset.get(p.getValueAsString());
        }
    }

    public static class NewLineSerializer
    extends JsonSerializer<NewLine> {
        public void serialize(NewLine value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.getId());
        }
    }

    public static class NewLineDeserializer
    extends JsonDeserializer<NewLine> {
        public NewLine deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return NewLine.byId(p.getValueAsString());
        }
    }

    public static class LocalPathSerializer
    extends JsonSerializer<Path> {
        public void serialize(Path value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.toString());
        }
    }

    public static class LocalPathDeserializer
    extends JsonDeserializer<Path> {
        public Path deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Path.of(p.getValueAsString(), new String[0]);
        }
    }

    public static class OsTypeSerializer
    extends JsonSerializer<OsType> {
        public void serialize(OsType value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.getName());
        }
    }

    public static class OsTypeLocalDeserializer
    extends JsonDeserializer<OsType.Local> {
        public OsType.Local deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Stream<OsType.Any> stream = Stream.of(OsType.WINDOWS, OsType.LINUX, OsType.MACOS);
            String n = p.getValueAsString();
            return stream.filter(osType -> osType.getName().equals(n)).findFirst().orElse(null);
        }
    }

    public static class OsTypeAnyDeserializer
    extends JsonDeserializer<OsType.Any> {
        public OsType.Any deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Stream<OsType.Any> stream = Stream.of(OsType.WINDOWS, OsType.LINUX, OsType.BSD, OsType.SOLARIS, OsType.MACOS);
            String n = p.getValueAsString();
            return stream.filter(osType -> osType.getName().equals(n)).findFirst().orElse(null);
        }
    }

    public static class ShellScriptSerializer
    extends JsonSerializer<ShellScript> {
        public void serialize(ShellScript value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.getValue());
        }
    }

    public static class ShellScriptDeserializer
    extends JsonDeserializer<ShellScript> {
        public ShellScript deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new ShellScript(p.getValueAsString());
        }
    }

    @JsonSerialize(as=Throwable.class)
    public static abstract class ThrowableTypeMixIn {
        @JsonIdentityInfo(generator=ObjectIdGenerators.StringIdGenerator.class, property="$id")
        private Throwable cause;
    }
}

