/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class StorePath {
    public static final char SEPARATOR = '/';
    private final List<String> names;

    @JsonCreator
    public StorePath(List<String> names) {
        this.names = names;
    }

    public static StorePath create(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException("Names are null");
        }
        if (Arrays.stream(names).anyMatch(s -> s == null)) {
            throw new IllegalArgumentException("Name is null");
        }
        if (Arrays.stream(names).anyMatch(s -> s.contains("/"))) {
            throw new IllegalArgumentException("Separator character / is not allowed in the names");
        }
        if (Arrays.stream(names).anyMatch(s -> s.trim().length() == 0)) {
            throw new IllegalArgumentException("Trimmed entry name is empty");
        }
        return new StorePath(Arrays.stream(names).toList());
    }

    public static StorePath fromString(String s) {
        if (s == null) {
            throw new IllegalArgumentException("String is null");
        }
        String[] split = s.split(String.valueOf('/'), -1);
        List<String> names = Arrays.stream(split).map(String::trim).map(String::toLowerCase).toList();
        if (names.stream().anyMatch(s1 -> s1.isEmpty())) {
            throw new IllegalArgumentException("Name must not be empty");
        }
        return new StorePath(names);
    }

    public String toString() {
        return this.names.stream().map(String::toLowerCase).collect(Collectors.joining("/"));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StorePath)) {
            return false;
        }
        StorePath other = (StorePath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        return !(this$names == null ? other$names != null : !((Object)this$names).equals(other$names));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StorePath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        return result;
    }

    public List<String> getNames() {
        return this.names;
    }
}

