/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.store.ExpandedLifecycleStore;
import io.xpipe.core.store.InternalCacheDataStore;
import io.xpipe.core.store.Session;
import io.xpipe.core.store.SessionListener;

public interface SingletonSessionStore<T extends Session>
extends ExpandedLifecycleStore,
InternalCacheDataStore,
SessionListener {
    @Override
    default public void finalizeStore() throws Exception {
        this.stopSessionIfNeeded();
    }

    default public void setSessionEnabled(boolean value) {
        this.setCache("sessionEnabled", value);
    }

    default public boolean isSessionRunning() {
        return this.getCache("sessionRunning", Boolean.class, false);
    }

    default public boolean isSessionEnabled() {
        return this.getCache("sessionEnabled", Boolean.class, false);
    }

    @Override
    default public void onStateChange(boolean running) {
        this.setSessionEnabled(running);
        this.setCache("sessionRunning", running);
    }

    public T newSession() throws Exception;

    public Class<?> getSessionClass();

    default public T getSession() {
        return (T)((Session)this.getCache("session", this.getSessionClass(), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void startSessionIfNeeded() throws Exception {
        SingletonSessionStore singletonSessionStore = this;
        synchronized (singletonSessionStore) {
            T s = this.getSession();
            if (s != null) {
                if (((Session)s).isRunning()) {
                    return;
                }
                ((Session)s).start();
                return;
            }
            try {
                this.setSessionEnabled(true);
                s = this.newSession();
                if (s != null) {
                    ((Session)s).start();
                    this.setCache("session", s);
                    this.onStateChange(true);
                } else {
                    this.setSessionEnabled(false);
                }
            }
            catch (Exception ex) {
                this.setSessionEnabled(false);
                this.onStateChange(false);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void stopSessionIfNeeded() throws Exception {
        SingletonSessionStore singletonSessionStore = this;
        synchronized (singletonSessionStore) {
            T ex = this.getSession();
            this.setSessionEnabled(false);
            if (ex != null) {
                try {
                    ((Session)ex).stop();
                }
                finally {
                    this.setCache("session", null);
                    this.onStateChange(false);
                }
            }
        }
    }
}

