/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.store.DataStore;
import io.xpipe.core.store.NetworkTunnelSession;
import io.xpipe.core.store.NetworkTunnelSessionChain;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public interface NetworkTunnelStore
extends DataStore {
    public static final AtomicInteger portCounter = new AtomicInteger();

    public static int randomPort() {
        int p = 40000 + portCounter.get();
        portCounter.set(portCounter.get() + 1);
        return p;
    }

    public DataStore getNetworkParent();

    default public boolean requiresTunnel() {
        return this.getNetworkParent() != null;
    }

    default public boolean isLocallyTunnelable() {
        NetworkTunnelStore current = this;
        while (true) {
            NetworkTunnelStore t;
            DataStore p;
            if ((p = current.getNetworkParent()) == null) {
                return true;
            }
            if (!(p instanceof NetworkTunnelStore)) break;
            current = t = (NetworkTunnelStore)p;
        }
        return false;
    }

    default public NetworkTunnelSession sessionChain(int local, int remotePort, String address) throws Exception {
        if (!this.isLocallyTunnelable()) {
            throw new IllegalStateException("Unable to create tunnel chain as one intermediate system does not support tunneling");
        }
        ArrayList<NetworkTunnelSession> sessions = new ArrayList<NetworkTunnelSession>();
        NetworkTunnelStore current = this;
        while (current.getNetworkParent() != null) {
            int currentLocalPort = current.isLast() ? local : NetworkTunnelStore.randomPort();
            int currentRemotePort = sessions.isEmpty() ? remotePort : ((NetworkTunnelSession)sessions.getLast()).getLocalPort();
            NetworkTunnelSession t = current.createTunnelSession(currentLocalPort, currentRemotePort, current == this ? address : "localhost");
            sessions.addFirst(t);
            if ((current = (NetworkTunnelStore)current.getNetworkParent()) != null) continue;
        }
        if (sessions.size() == 1) {
            return (NetworkTunnelSession)sessions.getFirst();
        }
        if (sessions.isEmpty()) {
            return null;
        }
        return new NetworkTunnelSessionChain(running1 -> {}, sessions);
    }

    default public boolean isLast() {
        NetworkTunnelStore n;
        DataStore dataStore;
        return this.getNetworkParent() != null && (dataStore = this.getNetworkParent()) instanceof NetworkTunnelStore && (n = (NetworkTunnelStore)dataStore).getNetworkParent() == null;
    }

    public NetworkTunnelSession createTunnelSession(int var1, int var2, String var3) throws Exception;
}

