/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.process.ShellControl;
import io.xpipe.core.store.NetworkTunnelSession;
import io.xpipe.core.store.SessionListener;
import java.util.List;

public class NetworkTunnelSessionChain
extends NetworkTunnelSession {
    private final List<NetworkTunnelSession> sessions;

    public NetworkTunnelSessionChain(SessionListener listener, List<NetworkTunnelSession> sessions) {
        super(listener);
        this.sessions = sessions;
    }

    @Override
    public ShellControl getShellControl() {
        return this.sessions.getLast().getShellControl();
    }

    @Override
    public int getLocalPort() {
        return this.sessions.getFirst().getLocalPort();
    }

    @Override
    public int getRemotePort() {
        return this.sessions.getLast().getRemotePort();
    }

    @Override
    public boolean isRunning() throws Exception {
        for (NetworkTunnelSession session : this.sessions) {
            if (session.isRunning()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void start() throws Exception {
        for (int i = 0; i < this.sessions.size(); ++i) {
            try {
                this.sessions.get(i).start();
                continue;
            }
            catch (Exception e) {
                for (int j = 0; j < i; ++j) {
                    NetworkTunnelSession started = this.sessions.get(j);
                    try {
                        started.stop();
                        continue;
                    }
                    catch (Exception stopEx) {
                        e.addSuppressed(stopEx);
                    }
                }
                throw e;
            }
        }
    }

    @Override
    public void stop() throws Exception {
        Exception ex = null;
        for (int i = this.sessions.size() - 1; i >= 0; --i) {
            try {
                this.sessions.get(i).stop();
                continue;
            }
            catch (Exception e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }
}

