/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.store.FileEntry;
import io.xpipe.core.store.FileInfo;
import io.xpipe.core.store.FileKind;
import io.xpipe.core.store.FileSystem;
import java.time.Instant;
import lombok.NonNull;

public final class LinkFileEntry
extends FileEntry {
    @NonNull
    private final FileEntry target;

    public LinkFileEntry(FileSystem fileSystem, @NonNull String path, Instant date, long size, @NonNull FileInfo info, @NonNull FileEntry target) {
        super(fileSystem, path, date, size, info, FileKind.LINK);
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.target = target;
    }

    @Override
    public FileEntry resolved() {
        return this.target;
    }

    @NonNull
    public FileEntry getTarget() {
        return this.target;
    }

    @Override
    public String toString() {
        return "LinkFileEntry(target=" + String.valueOf(this.getTarget()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkFileEntry)) {
            return false;
        }
        LinkFileEntry other = (LinkFileEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileEntry this$target = this.getTarget();
        FileEntry other$target = other.getTarget();
        return !(this$target == null ? other$target != null : !((Object)this$target).equals(other$target));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LinkFileEntry;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        FileEntry $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        return result;
    }
}

