/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.process.ShellControl;
import io.xpipe.core.store.FileEntry;
import io.xpipe.core.store.FileKind;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public interface FileSystem
extends Closeable,
AutoCloseable {
    public long getFileSize(String var1) throws Exception;

    public Optional<ShellControl> getShell();

    public FileSystem open() throws Exception;

    public InputStream openInput(String var1) throws Exception;

    public OutputStream openOutput(String var1, long var2) throws Exception;

    public boolean fileExists(String var1) throws Exception;

    public void delete(String var1) throws Exception;

    public void copy(String var1, String var2) throws Exception;

    public void move(String var1, String var2) throws Exception;

    public void mkdirs(String var1) throws Exception;

    public void touch(String var1) throws Exception;

    public void symbolicLink(String var1, String var2) throws Exception;

    public boolean directoryExists(String var1) throws Exception;

    public void directoryAccessible(String var1) throws Exception;

    public Stream<FileEntry> listFiles(String var1) throws Exception;

    default public List<FileEntry> listFilesRecursively(String file) throws Exception {
        List<FileEntry> base;
        try (Stream<FileEntry> filesStream = this.listFiles(file);){
            base = filesStream.toList();
        }
        return base.stream().flatMap(fileEntry -> {
            if (fileEntry.getKind() != FileKind.DIRECTORY) {
                return Stream.of(fileEntry);
            }
            try {
                ArrayList<FileEntry> list = new ArrayList<FileEntry>();
                list.add((FileEntry)fileEntry);
                list.addAll(this.listFilesRecursively(fileEntry.getPath()));
                return list.stream();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).toList();
    }

    public List<String> listRoots() throws Exception;
}

