/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

public sealed interface FileInfo {
    public boolean explicitlyHidden();

    public boolean possiblyExecutable();

    public static final class Unix
    implements FileInfo {
        private final String permissions;
        private final Integer uid;
        private final String user;
        private final Integer gid;
        private final String group;

        @Override
        public boolean explicitlyHidden() {
            return false;
        }

        @Override
        public boolean possiblyExecutable() {
            return this.permissions.contains("x");
        }

        public Unix(String permissions, Integer uid, String user, Integer gid, String group) {
            this.permissions = permissions;
            this.uid = uid;
            this.user = user;
            this.gid = gid;
            this.group = group;
        }

        public String getPermissions() {
            return this.permissions;
        }

        public Integer getUid() {
            return this.uid;
        }

        public String getUser() {
            return this.user;
        }

        public Integer getGid() {
            return this.gid;
        }

        public String getGroup() {
            return this.group;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unix)) {
                return false;
            }
            Unix other = (Unix)o;
            Integer this$uid = this.getUid();
            Integer other$uid = other.getUid();
            if (this$uid == null ? other$uid != null : !((Object)this$uid).equals(other$uid)) {
                return false;
            }
            Integer this$gid = this.getGid();
            Integer other$gid = other.getGid();
            if (this$gid == null ? other$gid != null : !((Object)this$gid).equals(other$gid)) {
                return false;
            }
            String this$permissions = this.getPermissions();
            String other$permissions = other.getPermissions();
            if (this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            return !(this$group == null ? other$group != null : !this$group.equals(other$group));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $uid = this.getUid();
            result = result * 59 + ($uid == null ? 43 : ((Object)$uid).hashCode());
            Integer $gid = this.getGid();
            result = result * 59 + ($gid == null ? 43 : ((Object)$gid).hashCode());
            String $permissions = this.getPermissions();
            result = result * 59 + ($permissions == null ? 43 : $permissions.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            return result;
        }

        public String toString() {
            return "FileInfo.Unix(permissions=" + this.getPermissions() + ", uid=" + this.getUid() + ", user=" + this.getUser() + ", gid=" + this.getGid() + ", group=" + this.getGroup() + ")";
        }
    }

    public static final class Windows
    implements FileInfo {
        private final String attributes;

        @Override
        public boolean explicitlyHidden() {
            return this.attributes.contains("h");
        }

        @Override
        public boolean possiblyExecutable() {
            return true;
        }

        public Windows(String attributes) {
            this.attributes = attributes;
        }

        public String getAttributes() {
            return this.attributes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Windows)) {
                return false;
            }
            Windows other = (Windows)o;
            String this$attributes = this.getAttributes();
            String other$attributes = other.getAttributes();
            return !(this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : $attributes.hashCode());
            return result;
        }

        public String toString() {
            return "FileInfo.Windows(attributes=" + this.getAttributes() + ")";
        }
    }
}

