/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.store.FileInfo;
import io.xpipe.core.store.FileKind;
import io.xpipe.core.store.FileNames;
import io.xpipe.core.store.FilePath;
import io.xpipe.core.store.FileSystem;
import java.time.Instant;
import lombok.NonNull;

public class FileEntry {
    private final FileSystem fileSystem;
    private final Instant date;
    private final long size;
    private final FileInfo info;
    @NonNull
    private final FileKind kind;
    @NonNull
    private String path;

    public FileEntry(FileSystem fileSystem, @NonNull String path, Instant date, long size, FileInfo info, @NonNull FileKind kind) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        this.fileSystem = fileSystem;
        this.kind = kind;
        this.path = kind == FileKind.DIRECTORY ? new FilePath(path).toDirectory().toString() : path;
        this.date = date;
        this.info = info;
        this.size = size;
    }

    public static FileEntry ofDirectory(FileSystem fileSystem, String path) {
        return new FileEntry(fileSystem, path, Instant.now(), 0L, null, FileKind.DIRECTORY);
    }

    public FileEntry resolved() {
        return this;
    }

    public String getName() {
        return FileNames.getFileName(this.path);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Instant getDate() {
        return this.date;
    }

    public long getSize() {
        return this.size;
    }

    public FileInfo getInfo() {
        return this.info;
    }

    @NonNull
    public FileKind getKind() {
        return this.kind;
    }

    @NonNull
    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileEntry)) {
            return false;
        }
        FileEntry other = (FileEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        FileSystem this$fileSystem = this.getFileSystem();
        FileSystem other$fileSystem = other.getFileSystem();
        if (this$fileSystem == null ? other$fileSystem != null : !this$fileSystem.equals(other$fileSystem)) {
            return false;
        }
        Instant this$date = this.getDate();
        Instant other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        FileInfo this$info = this.getInfo();
        FileInfo other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
            return false;
        }
        FileKind this$kind = this.getKind();
        FileKind other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        FileSystem $fileSystem = this.getFileSystem();
        result = result * 59 + ($fileSystem == null ? 43 : $fileSystem.hashCode());
        Instant $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        FileInfo $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        FileKind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    public String toString() {
        return "FileEntry(fileSystem=" + String.valueOf(this.getFileSystem()) + ", date=" + String.valueOf(this.getDate()) + ", size=" + this.getSize() + ", info=" + String.valueOf(this.getInfo()) + ", kind=" + String.valueOf((Object)this.getKind()) + ", path=" + this.getPath() + ")";
    }

    public void setPath(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.path = path;
    }
}

