/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.OsType;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.process.ShellDialect;
import io.xpipe.core.store.FilePath;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;

public class ShellView {
    protected final ShellControl shellControl;

    public ShellView(ShellControl shellControl) {
        this.shellControl = shellControl;
    }

    protected ShellDialect getDialect() {
        return this.shellControl.getShellDialect();
    }

    public void writeTextFile(FilePath path, String text) throws Exception {
        CommandControl cc = this.getDialect().createTextFileWriteCommand(this.shellControl, text, path.toString());
        cc.execute();
    }

    public void writeScriptFile(FilePath path, String text) throws Exception {
        CommandControl cc = this.getDialect().createScriptTextFileWriteCommand(this.shellControl, text, path.toString());
        cc.execute();
    }

    public void writeStreamFile(FilePath path, InputStream inputStream, long size) throws Exception {
        try (OutputStream out = this.getDialect().createStreamFileWriteCommand(this.shellControl, path.toString(), size).startExternalStdin();){
            inputStream.transferTo(out);
        }
    }

    public FilePath userHome() throws Exception {
        return new FilePath(this.shellControl.getOsType().getUserHomeDirectory(this.shellControl));
    }

    public boolean fileExists(FilePath path) throws Exception {
        return this.getDialect().createFileExistsCommand(this.shellControl, path.toString()).executeAndCheck();
    }

    public String user() throws Exception {
        return this.getDialect().printUsernameCommand(this.shellControl).readStdoutOrThrow();
    }

    public String getPath() throws Exception {
        String path = this.shellControl.command(this.shellControl.getShellDialect().getPrintEnvironmentVariableCommand("PATH")).readStdoutOrThrow();
        return path;
    }

    public String getLibraryPath() throws Exception {
        String path = this.shellControl.command(this.shellControl.getShellDialect().getPrintEnvironmentVariableCommand("LD_LIBRARY_PATH")).readStdoutOrThrow();
        return path;
    }

    public boolean isRoot() throws Exception {
        if (this.shellControl.getOsType() == OsType.WINDOWS) {
            return false;
        }
        boolean isRoot = this.shellControl.executeSimpleBooleanCommand("test \"${EUID:-$(id -u)}\" -eq 0");
        return isRoot;
    }

    public Optional<String> findProgram(String name) throws Exception {
        Optional<String> out = this.shellControl.command(this.shellControl.getShellDialect().getWhichCommand(name)).readStdoutIfPossible();
        return out.flatMap(s -> s.lines().findFirst()).map(String::trim);
    }

    public boolean isInPath(String executable) throws Exception {
        return this.shellControl.executeSimpleBooleanCommand(this.shellControl.getShellDialect().getWhichCommand(executable));
    }
}

