/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.ShellControl;
import io.xpipe.core.process.ShellDialect;
import java.util.Optional;
import lombok.NonNull;

public interface ShellInitCommand {
    default public void runDumb(ShellControl shellControl) throws Exception {
        throw new UnsupportedOperationException();
    }

    default public Optional<String> terminalContent(ShellControl shellControl) throws Exception {
        throw new UnsupportedOperationException();
    }

    default public boolean runInDumb() {
        return false;
    }

    public boolean canPotentiallyRunInDialect(ShellDialect var1);

    default public boolean runInTerminal() {
        return false;
    }

    public static class Simple
    implements ShellInitCommand {
        @NonNull
        private final String content;
        private final ShellDialect dialect;
        private final boolean dumb;
        private final boolean terminal;

        public Simple(@NonNull String content, ShellDialect dialect, boolean dumb, boolean terminal) {
            if (content == null) {
                throw new NullPointerException("content is marked non-null but is null");
            }
            this.content = content;
            this.dialect = dialect;
            this.dumb = dumb;
            this.terminal = terminal;
        }

        @Override
        public void runDumb(ShellControl shellControl) throws Exception {
            shellControl.executeSimpleCommand(this.content);
        }

        @Override
        public Optional<String> terminalContent(ShellControl shellControl) {
            return Optional.of(this.content);
        }

        @Override
        public boolean runInDumb() {
            return this.dumb;
        }

        @Override
        public boolean canPotentiallyRunInDialect(ShellDialect dialect) {
            return this.dialect.isCompatibleTo(dialect);
        }

        @Override
        public boolean runInTerminal() {
            return this.terminal;
        }
    }

    public static interface Terminal
    extends ShellInitCommand {
        @Override
        public Optional<String> terminalContent(ShellControl var1);

        @Override
        default public boolean runInTerminal() {
            return true;
        }
    }
}

