/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.CommandBuilder;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.process.ShellDialect;
import io.xpipe.core.process.ShellOpenFunction;
import java.io.IOException;

public interface ShellDumbMode {
    default public boolean supportsAnyPossibleInteraction() {
        return true;
    }

    default public void throwIfUnsupported() {
    }

    default public ShellDialect getSwitchDialect() {
        return null;
    }

    default public CommandBuilder prepareInlineDumbCommand(ShellControl self, ShellControl parent, ShellOpenFunction function) throws Exception {
        return function.prepareWithoutInitCommand();
    }

    default public void prepareInlineShellSwitch(ShellControl shellControl) throws Exception {
    }

    default public void prepareDumbInit(ShellControl shellControl) throws Exception {
    }

    default public void prepareDumbExit(ShellControl shellControl) throws IOException {
        shellControl.writeLine(" exit");
    }

    public static class Unsupported
    implements ShellDumbMode {
        private final String message;

        public Unsupported(String message) {
            this.message = message;
        }

        @Override
        public void throwIfUnsupported() {
            throw new UnsupportedOperationException(this.message);
        }

        @Override
        public boolean supportsAnyPossibleInteraction() {
            return false;
        }

        @Override
        public CommandBuilder prepareInlineDumbCommand(ShellControl self, ShellControl parent, ShellOpenFunction function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void prepareDumbInit(ShellControl shellControl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void prepareDumbExit(ShellControl shellControl) {
            shellControl.kill();
        }
    }
}

