/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.ShellControl;
import io.xpipe.core.process.ShellDialect;
import io.xpipe.core.util.ModuleLayerLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;

public class ShellDialects {
    public static final List<ShellDialect> ALL = new ArrayList<ShellDialect>();
    public static ShellDialect OPNSENSE;
    public static ShellDialect PFSENSE;
    public static ShellDialect POWERSHELL;
    public static ShellDialect POWERSHELL_CORE;
    public static ShellDialect CMD;
    public static ShellDialect ASH;
    public static ShellDialect SH;
    public static ShellDialect DASH;
    public static ShellDialect BASH;
    public static ShellDialect ZSH;
    public static ShellDialect CSH;
    public static ShellDialect FISH;
    public static ShellDialect NO_INTERACTION;
    public static ShellDialect CISCO;
    public static ShellDialect MIKROTIK;
    public static ShellDialect RBASH;
    public static ShellDialect CONSTRAINED_POWERSHELL;
    public static ShellDialect OVH_BASTION;

    public static List<ShellDialect> getStartableDialects() {
        return ALL.stream().filter(dialect -> dialect.getLaunchCommand() != null).toList();
    }

    private static ShellDialect byId(String name) {
        return ALL.stream().filter(shellType -> shellType.getId().equals(name)).findFirst().orElseThrow();
    }

    public static boolean isPowershell(ShellControl sc) {
        if (sc.getShellDialect() == null) {
            return false;
        }
        return ShellDialects.isPowershell(sc.getShellDialect());
    }

    public static boolean isPowershell(ShellDialect d) {
        return d == POWERSHELL || d == POWERSHELL_CORE;
    }

    public static Optional<ShellDialect> byNameIfPresent(String name) {
        return ALL.stream().filter(shellType -> shellType.getId().equals(name)).findFirst();
    }

    public static class Loader
    implements ModuleLayerLoader {
        @Override
        public void init(ModuleLayer layer) {
            ServiceLoader<ShellDialect> services = layer != null ? ServiceLoader.load(layer, ShellDialect.class) : ServiceLoader.load(ShellDialect.class);
            services.stream().forEach(moduleLayerLoaderProvider -> ALL.add((ShellDialect)moduleLayerLoaderProvider.get()));
            if (ALL.isEmpty()) {
                return;
            }
            CMD = ShellDialects.byId("cmd");
            POWERSHELL = ShellDialects.byId("powershell");
            POWERSHELL_CORE = ShellDialects.byId("pwsh");
            OPNSENSE = ShellDialects.byId("opnsense");
            PFSENSE = ShellDialects.byId("pfsense");
            FISH = ShellDialects.byId("fish");
            DASH = ShellDialects.byId("dash");
            BASH = ShellDialects.byId("bash");
            ZSH = ShellDialects.byId("zsh");
            CSH = ShellDialects.byId("csh");
            ASH = ShellDialects.byId("ash");
            SH = ShellDialects.byId("sh");
            NO_INTERACTION = ShellDialects.byId("noInteraction");
            CISCO = ShellDialects.byId("cisco");
            MIKROTIK = ShellDialects.byId("mikrotik");
            RBASH = ShellDialects.byId("rbash");
            CONSTRAINED_POWERSHELL = ShellDialects.byId("constrainedPowershell");
            OVH_BASTION = ShellDialects.byId("ovhBastion");
        }
    }
}

