/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.CommandBuilder;
import io.xpipe.core.process.CommandConfiguration;
import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.CountDown;
import io.xpipe.core.process.ElevationFunction;
import io.xpipe.core.process.ElevationHandler;
import io.xpipe.core.process.LocalProcessInputStream;
import io.xpipe.core.process.LocalProcessOutputStream;
import io.xpipe.core.process.OsType;
import io.xpipe.core.process.ParentSystemAccess;
import io.xpipe.core.process.ProcessControl;
import io.xpipe.core.process.ShellCapabilities;
import io.xpipe.core.process.ShellDialect;
import io.xpipe.core.process.ShellInitCommand;
import io.xpipe.core.process.ShellOpenFunction;
import io.xpipe.core.process.ShellScript;
import io.xpipe.core.process.ShellSecurityPolicy;
import io.xpipe.core.process.ShellStoreState;
import io.xpipe.core.process.ShellTtyState;
import io.xpipe.core.process.ShellView;
import io.xpipe.core.process.StubShellControl;
import io.xpipe.core.process.TerminalInitFunction;
import io.xpipe.core.process.TerminalInitScriptConfig;
import io.xpipe.core.process.WorkingDirectoryFunction;
import io.xpipe.core.store.DataStore;
import io.xpipe.core.store.DataStoreState;
import io.xpipe.core.store.FilePath;
import io.xpipe.core.store.StatefulDataStore;
import io.xpipe.core.util.FailableConsumer;
import io.xpipe.core.util.FailableFunction;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;

public interface ShellControl
extends ProcessControl {
    public void setDumbOpen(ShellOpenFunction var1);

    public void setTerminalOpen(ShellOpenFunction var1);

    public void writeLine(String var1) throws IOException;

    public void writeLine(String var1, boolean var2) throws IOException;

    public void write(byte[] var1) throws IOException;

    @Override
    public LocalProcessInputStream getStdout();

    @Override
    public LocalProcessOutputStream getStdin();

    @Override
    public LocalProcessInputStream getStderr();

    public ShellView view();

    public ShellCapabilities getCapabilities();

    public Optional<ShellControl> getParentControl();

    public ShellTtyState getTtyState();

    public void setNonInteractive();

    public boolean isInteractive();

    public ElevationHandler getElevationHandler();

    public void setElevationHandler(ElevationHandler var1);

    public void closeStdout() throws IOException;

    public List<UUID> getExitUuids();

    public void setWorkingDirectory(WorkingDirectoryFunction var1);

    public Optional<DataStore> getSourceStore();

    public Optional<UUID> getSourceStoreId();

    public ShellControl withSourceStore(DataStore var1);

    public List<ShellInitCommand> getInitCommands();

    public ParentSystemAccess getParentSystemAccess();

    public void setParentSystemAccess(ParentSystemAccess var1);

    public ParentSystemAccess getLocalSystemAccess();

    public boolean isLocal();

    default public boolean canHaveSubshells() {
        return true;
    }

    public ShellControl getMachineRootSession();

    public String getOsName();

    public ReentrantLock getLock();

    public void requireLicensedFeature(String var1);

    public ShellDialect getOriginalShellDialect();

    public void setOriginalShellDialect(ShellDialect var1);

    public ShellControl onInit(FailableConsumer<ShellControl, Exception> var1);

    default public <T extends ShellStoreState> ShellControl withShellStateInit(StatefulDataStore<T> store) {
        return this.onInit(shellControl -> {
            DataStoreState s = ((ShellStoreState.ShellStoreStateBuilder)((ShellStoreState.ShellStoreStateBuilder)((ShellStoreState.ShellStoreStateBuilder)((ShellStoreState.ShellStoreStateBuilder)((ShellStoreState.ShellStoreStateBuilder)((ShellStoreState)store.getState()).toBuilder().osType(shellControl.getOsType())).shellDialect(shellControl.getOriginalShellDialect())).ttyState(shellControl.getTtyState())).running(true)).osName(shellControl.getOsName())).build();
            store.setState((ShellStoreState)s.asNeeded());
        });
    }

    default public <T extends ShellStoreState> ShellControl withShellStateFail(StatefulDataStore<T> store) {
        return this.onStartupFail(t -> {
            if (t.getClass().getSimpleName().equals("LicenseRequiredException")) {
                return;
            }
            DataStoreState s = ((ShellStoreState.ShellStoreStateBuilder)((ShellStoreState)store.getState()).toBuilder().running(false)).build();
            store.setState((ShellStoreState)s.asNeeded());
        });
    }

    public ShellControl onExit(Consumer<ShellControl> var1);

    public ShellControl onKill(Runnable var1);

    public ShellControl onStartupFail(Consumer<Throwable> var1);

    @Override
    public ShellControl withExceptionConverter(ProcessControl.ExceptionConverter var1);

    @Override
    public ShellControl start() throws Exception;

    public ShellControl withErrorFormatter(Function<String, String> var1);

    public void checkLicenseOrThrow();

    public String prepareIntermediateTerminalOpen(TerminalInitFunction var1, TerminalInitScriptConfig var2, WorkingDirectoryFunction var3) throws Exception;

    public FilePath getSystemTemporaryDirectory();

    default public CommandControl osascriptCommand(String script) {
        return this.command(String.format("osascript - \"$@\" <<EOF\n%s\nEOF\n", script));
    }

    default public String executeSimpleStringCommand(String command) throws Exception {
        try (CommandControl c = this.command(command).start();){
            String string = c.readStdoutOrThrow();
            return string;
        }
    }

    default public boolean executeSimpleBooleanCommand(String command) throws Exception {
        try (CommandControl c = this.command(command).start();){
            boolean bl = c.discardAndCheckExit();
            return bl;
        }
    }

    default public void executeSimpleCommand(CommandBuilder command) throws Exception {
        try (CommandControl c = this.command(command).start();){
            c.discardOrThrow();
        }
    }

    default public void executeSimpleCommand(String command) throws Exception {
        try (CommandControl c = this.command(command).start();){
            c.discardOrThrow();
        }
    }

    public ShellControl withSecurityPolicy(ShellSecurityPolicy var1);

    public ShellSecurityPolicy getEffectiveSecurityPolicy();

    public String buildElevatedCommand(CommandConfiguration var1, String var2, UUID var3, CountDown var4) throws Exception;

    public void restart() throws Exception;

    public OsType.Any getOsType();

    public ShellControl elevated(ElevationFunction var1);

    public ShellControl withInitSnippet(ShellInitCommand var1);

    default public ShellControl subShell(final @NonNull ShellDialect type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        ShellOpenFunction o = new ShellOpenFunction(){

            @Override
            public CommandBuilder prepareWithoutInitCommand() {
                return CommandBuilder.of().addAll(sc -> type.getLaunchCommand().loginCommand(sc.getOsType()));
            }

            @Override
            public CommandBuilder prepareWithInitCommand(@NonNull String command) {
                if (command == null) {
                    throw new NullPointerException("command is marked non-null but is null");
                }
                return CommandBuilder.ofString(command);
            }
        };
        ShellControl s = this.subShell();
        s.setDumbOpen(o);
        s.setTerminalOpen(o);
        s.setParentSystemAccess(ParentSystemAccess.identity());
        return s;
    }

    default public ShellControl identicalDialectSubShell() {
        ShellOpenFunction o = new ShellOpenFunction(this){

            @Override
            public CommandBuilder prepareWithoutInitCommand() {
                return CommandBuilder.of().addAll(sc -> sc.getShellDialect().getLaunchCommand().loginCommand(sc.getOsType()));
            }

            @Override
            public CommandBuilder prepareWithInitCommand(@NonNull String command) {
                if (command == null) {
                    throw new NullPointerException("command is marked non-null but is null");
                }
                return CommandBuilder.ofString(command);
            }
        };
        ShellControl sc = this.subShell();
        sc.setDumbOpen(o);
        sc.setTerminalOpen(o);
        sc.withSourceStore(this.getSourceStore().orElse(null));
        sc.setParentSystemAccess(ParentSystemAccess.identity());
        return sc;
    }

    default public ShellControl elevateIfNeeded(ElevationFunction function) throws Exception {
        if (function.apply(this)) {
            return this.identicalDialectSubShell().elevated(ElevationFunction.elevated(function.getPrefix()));
        }
        return new StubShellControl(this);
    }

    default public <T> T enforceDialect(@NonNull ShellDialect type, FailableFunction<ShellControl, T, Exception> sc) throws Exception {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (type.equals(this.getShellDialect())) {
            return sc.apply(this);
        }
        try (ShellControl sub = this.subShell(type).start();){
            T t = sc.apply(sub);
            return t;
        }
    }

    public ShellControl subShell();

    public void cd(String var1) throws Exception;

    default public CommandControl command(String command) {
        return this.command(CommandBuilder.ofFunction(shellProcessControl -> command));
    }

    default public CommandControl command(ShellScript command) {
        return this.command(CommandBuilder.of().add(command.getValue()));
    }

    default public CommandControl command(Consumer<CommandBuilder> builder) {
        CommandBuilder b = CommandBuilder.of();
        builder.accept(b);
        return this.command(b);
    }

    public CommandControl command(CommandBuilder var1);

    public void exitAndWait() throws IOException;
}

