/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

public interface ParentSystemAccess {
    public static ParentSystemAccess none() {
        return new ParentSystemAccess(){

            @Override
            public boolean supportsSameUsers() {
                return false;
            }

            @Override
            public boolean supportsFileSystemAccess() {
                return false;
            }

            @Override
            public boolean supportsExecutables() {
                return false;
            }

            @Override
            public boolean supportsExecutableEnvironment() {
                return false;
            }

            @Override
            public String translateFromLocalSystemPath(String path) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String translateToLocalSystemPath(String path) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isIdentity() {
                return false;
            }
        };
    }

    public static ParentSystemAccess identity() {
        return new ParentSystemAccess(){

            @Override
            public boolean supportsSameUsers() {
                return true;
            }

            @Override
            public boolean supportsFileSystemAccess() {
                return true;
            }

            @Override
            public boolean supportsExecutables() {
                return true;
            }

            @Override
            public boolean supportsExecutableEnvironment() {
                return true;
            }

            @Override
            public String translateFromLocalSystemPath(String path) {
                return path;
            }

            @Override
            public String translateToLocalSystemPath(String path) {
                return path;
            }

            @Override
            public boolean isIdentity() {
                return true;
            }
        };
    }

    public static ParentSystemAccess combine(final ParentSystemAccess a1, final ParentSystemAccess a2) {
        return new ParentSystemAccess(){

            @Override
            public boolean supportsSameUsers() {
                return a1.supportsSameUsers() && a2.supportsSameUsers();
            }

            @Override
            public boolean supportsFileSystemAccess() {
                return a1.supportsFileSystemAccess() && a2.supportsFileSystemAccess();
            }

            @Override
            public boolean supportsExecutables() {
                return a1.supportsExecutables() && a2.supportsExecutables();
            }

            @Override
            public boolean supportsExecutableEnvironment() {
                return a1.supportsExecutableEnvironment() && a2.supportsExecutableEnvironment();
            }

            @Override
            public String translateFromLocalSystemPath(String path) throws Exception {
                return a2.translateFromLocalSystemPath(a1.translateFromLocalSystemPath(path));
            }

            @Override
            public String translateToLocalSystemPath(String path) throws Exception {
                return a1.translateToLocalSystemPath(a2.translateToLocalSystemPath(path));
            }

            @Override
            public boolean isIdentity() {
                return a1.isIdentity() && a2.isIdentity();
            }
        };
    }

    default public boolean supportsAnyAccess() {
        return this.supportsFileSystemAccess();
    }

    public boolean supportsSameUsers();

    public boolean supportsFileSystemAccess();

    public boolean supportsExecutables();

    public boolean supportsExecutableEnvironment();

    public String translateFromLocalSystemPath(String var1) throws Exception;

    public String translateToLocalSystemPath(String var1) throws Exception;

    public boolean isIdentity();
}

