/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.ShellControl;
import io.xpipe.core.store.FileNames;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public interface OsType {
    public static final Windows WINDOWS = new Windows();
    public static final Linux LINUX = new Linux();
    public static final MacOs MACOS = new MacOs();
    public static final Bsd BSD = new Bsd();
    public static final Solaris SOLARIS = new Solaris();

    public static Local getLocal() {
        String osName = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (osName.contains("mac") || osName.contains("darwin")) {
            return MACOS;
        }
        if (osName.contains("win")) {
            return WINDOWS;
        }
        return LINUX;
    }

    public String makeFileSystemCompatible(String var1);

    public List<String> determineInterestingPaths(ShellControl var1) throws Exception;

    public String getUserHomeDirectory(ShellControl var1) throws Exception;

    public String getFileSystemSeparator();

    public String getName();

    public static final class MacOs
    implements OsType,
    Local,
    Any {
        @Override
        public String getId() {
            return "macos";
        }

        @Override
        public String makeFileSystemCompatible(String name) {
            return name.replaceAll("[\\\\/:]", "_").replaceAll("\u0000", "");
        }

        @Override
        public List<String> determineInterestingPaths(ShellControl pc) throws Exception {
            String home = this.getUserHomeDirectory(pc);
            return List.of(home, FileNames.join(home, "Downloads"), FileNames.join(home, "Documents"), FileNames.join(home, "Desktop"), "/Applications", "/Library", "/System", "/etc");
        }

        @Override
        public String getUserHomeDirectory(ShellControl pc) throws Exception {
            return pc.executeSimpleStringCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("HOME"));
        }

        @Override
        public String getFileSystemSeparator() {
            return "/";
        }

        @Override
        public String getName() {
            return "Mac";
        }
    }

    public static final class Windows
    implements OsType,
    Local,
    Any {
        @Override
        public String makeFileSystemCompatible(String name) {
            return name.replaceAll("[<>:\"/\\\\|?*]", "_").replaceAll("\\p{C}", "");
        }

        @Override
        public List<String> determineInterestingPaths(ShellControl pc) throws Exception {
            String home = this.getUserHomeDirectory(pc);
            return List.of(home, FileNames.join(home, "Documents"), FileNames.join(home, "Downloads"), FileNames.join(home, "Desktop"));
        }

        @Override
        public String getUserHomeDirectory(ShellControl pc) throws Exception {
            return pc.executeSimpleStringCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("USERPROFILE"));
        }

        @Override
        public String getFileSystemSeparator() {
            return "\\";
        }

        @Override
        public String getName() {
            return "Windows";
        }

        @Override
        public String getId() {
            return "windows";
        }
    }

    public static final class Linux
    extends Unix
    implements OsType,
    Local,
    Any {
        @Override
        public String getId() {
            return "linux";
        }
    }

    public static final class Bsd
    extends Unix
    implements Any {
    }

    public static final class Solaris
    extends Unix
    implements Any {
    }

    public static class Unix
    implements OsType {
        @Override
        public String makeFileSystemCompatible(String name) {
            return name.replaceAll("/\\\\", "_").replaceAll("\u0000", "");
        }

        @Override
        public List<String> determineInterestingPaths(ShellControl pc) throws Exception {
            String home = this.getUserHomeDirectory(pc);
            ArrayList<String> list = new ArrayList<String>(List.of(home, FileNames.join(home, "Downloads"), FileNames.join(home, "Documents"), "/etc", pc.getSystemTemporaryDirectory().toString(), "/var"));
            String parentHome = FileNames.getParent(home);
            if (parentHome != null && !parentHome.equals("/")) {
                list.add(3, parentHome);
            }
            return list;
        }

        @Override
        public String getUserHomeDirectory(ShellControl pc) throws Exception {
            String r = pc.executeSimpleStringCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("HOME"));
            if (r.isBlank()) {
                String user = pc.view().user();
                Optional<String> eval = pc.command("eval echo ~" + user).readStdoutIfPossible();
                if (eval.isPresent() && !eval.get().isBlank()) {
                    return eval.get();
                }
                if (user.equals("root")) {
                    return "/root";
                }
                return "/home/" + user;
            }
            return r;
        }

        @Override
        public String getFileSystemSeparator() {
            return "/";
        }

        @Override
        public String getName() {
            return "Linux";
        }
    }

    public static sealed interface Any
    extends OsType
    permits Windows, Linux, MacOs, Solaris, Bsd {
    }

    public static sealed interface Local
    extends OsType
    permits Windows, Linux, MacOs {
        public String getId();

        default public Any toAny() {
            return (Any)((Object)this);
        }
    }
}

