/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

public class CountDown {
    private volatile long lastMillis = -1L;
    private volatile long millisecondsLeft;
    private volatile boolean active;
    private volatile long maxMillis;

    private CountDown() {
    }

    public static CountDown of() {
        return new CountDown();
    }

    public synchronized void start(long millisecondsLeft) {
        this.millisecondsLeft = millisecondsLeft;
        this.maxMillis = millisecondsLeft;
        this.lastMillis = System.currentTimeMillis();
        this.active = true;
    }

    public void pause() {
        this.lastMillis = System.currentTimeMillis();
        this.setActive(false);
    }

    public void resume() {
        this.lastMillis = System.currentTimeMillis();
        this.setActive(true);
    }

    public synchronized boolean countDown() {
        long ml = System.currentTimeMillis();
        if (!this.active) {
            this.lastMillis = ml;
            return true;
        }
        long diff = ml - this.lastMillis;
        this.lastMillis = ml;
        this.millisecondsLeft -= diff;
        return this.millisecondsLeft >= 0L;
    }

    public synchronized long getMillisecondsElapsed() {
        return this.maxMillis - this.millisecondsLeft;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public long getMaxMillis() {
        return this.maxMillis;
    }
}

