/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.ElevationFunction;
import io.xpipe.core.process.ProcessControl;
import io.xpipe.core.process.ProcessOutputException;
import io.xpipe.core.process.ShellControl;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Function;

public interface CommandControl
extends ProcessControl {
    public static final int UNASSIGNED_EXIT_CODE = 160;
    public static final int EXIT_TIMEOUT_EXIT_CODE = 161;
    public static final int START_FAILED_EXIT_CODE = 162;
    public static final int INTERNAL_ERROR_EXIT_CODE = 163;
    public static final int ELEVATION_FAILED_EXIT_CODE = 164;

    public void setSensitive();

    @Override
    public CommandControl withExceptionConverter(ProcessControl.ExceptionConverter var1);

    @Override
    public CommandControl start() throws Exception;

    public CommandControl withErrorFormatter(Function<String, String> var1);

    public CommandControl terminalExitMode(TerminalExitMode var1);

    public CommandControl doesNotObeyReturnValueConvention();

    public CommandControl complex();

    public CommandControl notComplex();

    public CommandControl withWorkingDirectory(String var1);

    default public void execute() throws Exception {
        try (CommandControl c = this.start();){
            c.discardOrThrow();
        }
    }

    default public boolean executeAndCheck() throws Exception {
        try (CommandControl c = this.start();){
            boolean bl = c.discardAndCheckExit();
            return bl;
        }
    }

    public ShellControl getParent();

    public InputStream startExternalStdout() throws Exception;

    public OutputStream startExternalStdin() throws Exception;

    public void setExitTimeout(Duration var1);

    public boolean waitFor();

    public CommandControl withCustomCharset(Charset var1);

    public long getExitCode();

    public CommandControl elevated(ElevationFunction var1);

    public String[] readStdoutAndStderr() throws Exception;

    public void discardOrThrow() throws Exception;

    public byte[] readRawBytesOrThrow() throws Exception;

    public String readStdoutOrThrow() throws Exception;

    public Optional<String> readStdoutIfPossible() throws Exception;

    default public boolean discardAndCheckExit() throws ProcessOutputException {
        try {
            this.discardOrThrow();
            return true;
        }
        catch (ProcessOutputException ex) {
            if (ex.isIrregularExit()) {
                throw ex;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static enum TerminalExitMode {
        KEEP_OPEN,
        CLOSE;

    }
}

