/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.dialog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.xpipe.core.dialog.Choice;
import io.xpipe.core.dialog.DialogElement;
import java.util.List;

@JsonTypeName(value="choice")
public class ChoiceElement
extends DialogElement {
    private final String description;
    private final List<Choice> elements;
    private final boolean required;
    private final boolean quiet;
    private int selected;

    @JsonCreator
    public ChoiceElement(String description, List<Choice> elements, boolean required, boolean quiet, int selected) {
        if (elements.stream().allMatch(Choice::isDisabled)) {
            throw new IllegalArgumentException("All choices are disabled");
        }
        this.description = description;
        this.elements = elements;
        this.required = required;
        this.selected = selected;
        this.quiet = quiet;
    }

    @Override
    public String toDisplayString() {
        return this.description;
    }

    @Override
    public boolean requiresExplicitUserInput() {
        return this.required && this.selected == -1;
    }

    @Override
    public boolean apply(String value) {
        if (value == null) {
            return true;
        }
        if (value.length() == 1) {
            char c = value.charAt(0);
            if (Character.isDigit(c)) {
                this.selected = Integer.parseInt(value) - 1;
                return true;
            }
            for (int i = 0; i < this.elements.size(); ++i) {
                if (this.elements.get(i).getCharacter() == null || !this.elements.get(i).getCharacter().equals(Character.valueOf(c))) continue;
                this.selected = i;
                return true;
            }
        } else {
            for (int i = 0; i < this.elements.size(); ++i) {
                if (!this.elements.get(i).getDescription().equalsIgnoreCase(value)) continue;
                this.selected = i;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChoiceElement)) {
            return false;
        }
        ChoiceElement other = (ChoiceElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isRequired() != other.isRequired()) {
            return false;
        }
        if (this.isQuiet() != other.isQuiet()) {
            return false;
        }
        if (this.getSelected() != other.getSelected()) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<Choice> this$elements = this.getElements();
        List<Choice> other$elements = other.getElements();
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChoiceElement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isRequired() ? 79 : 97);
        result = result * 59 + (this.isQuiet() ? 79 : 97);
        result = result * 59 + this.getSelected();
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<Choice> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ChoiceElement(description=" + this.getDescription() + ", elements=" + String.valueOf(this.getElements()) + ", required=" + this.isRequired() + ", quiet=" + this.isQuiet() + ", selected=" + this.getSelected() + ")";
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Choice> getElements() {
        return this.elements;
    }

    public boolean isRequired() {
        return this.required;
    }

    public int getSelected() {
        return this.selected;
    }
}

