/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import io.xpipe.core.process.OsType;
import io.xpipe.core.store.FileNames;
import io.xpipe.core.util.ModuleHelper;
import io.xpipe.core.util.XPipeDaemonMode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;

public class XPipeInstallation {
    public static final String DATA_DIR_PROP = "io.xpipe.app.dataDir";
    private static final String STAGING_PROP = "io.xpipe.app.staging";
    private static final boolean staging = Optional.ofNullable(System.getProperty("io.xpipe.app.staging")).map(Boolean::parseBoolean).orElse(false);

    public static int getDefaultBeaconPort() {
        int offset = XPipeInstallation.isStaging() ? 1 : 0;
        return 21721 + offset;
    }

    private static String getPkgId() {
        return XPipeInstallation.isStaging() ? "io.xpipe.xpipe-ptb" : "io.xpipe.xpipe";
    }

    public static Path getLocalBeaconAuthFile() {
        return Path.of(System.getProperty("java.io.tmpdir"), XPipeInstallation.isStaging() ? "xpipe_ptb_auth" : "xpipe_auth");
    }

    public static String createExternalAsyncLaunchCommand(String installationBase, XPipeDaemonMode mode, String arguments, boolean restart) {
        String modeOption;
        Object suffix = arguments != null ? " " + arguments : "";
        String string = modeOption = mode != null ? " --mode " + mode.getDisplayName() : "";
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return "nohup \"" + installationBase + "/app/bin/xpiped\"" + modeOption + (String)suffix + " & disown";
        }
        if (OsType.getLocal().equals(OsType.MACOS)) {
            if (restart) {
                return "(sleep 1;open \"" + installationBase + "\" --args" + modeOption + (String)suffix + "</dev/null &>/dev/null) & disown";
            }
            return "open \"" + installationBase + "\" --args" + modeOption + (String)suffix;
        }
        return "\"" + FileNames.join(installationBase, XPipeInstallation.getDaemonExecutablePath(OsType.getLocal())) + "\"" + modeOption + (String)suffix;
    }

    public static String createExternalLaunchCommand(String command, String arguments, XPipeDaemonMode mode) {
        Object suffix = arguments != null ? " " + arguments : "";
        String modeOption = mode != null ? " --mode " + mode.getDisplayName() : null;
        return "\"" + command + "\"" + modeOption + (String)suffix;
    }

    public static Path getCurrentInstallationBasePath() {
        String name;
        Path path = XPipeInstallation.toRealPathIfPossible(Path.of(ProcessHandle.current().info().command().orElseThrow(), new String[0]));
        if (!path.isAbsolute()) {
            path = XPipeInstallation.toRealPathIfPossible(Path.of(System.getProperty("user.dir"), new String[0]).resolve(path));
        }
        if ((name = path.getFileName().toString()).endsWith("java") || name.endsWith("java.exe")) {
            boolean isImage = ModuleHelper.isImage();
            if (!isImage) {
                return Path.of(System.getProperty("user.dir"), new String[0]);
            }
            return XPipeInstallation.getLocalInstallationBasePathForJavaExecutable(path);
        }
        return XPipeInstallation.getLocalInstallationBasePathForDaemonExecutable(path);
    }

    private static Path toRealPathIfPossible(Path p) {
        try {
            return p.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return p;
        }
    }

    public static boolean isInstallationDistribution() {
        Path base = XPipeInstallation.getCurrentInstallationBasePath();
        if (OsType.getLocal().equals(OsType.MACOS)) {
            if (!base.toString().equals(XPipeInstallation.getLocalDefaultInstallationBasePath())) {
                return false;
            }
            try {
                Process process = new ProcessBuilder("pkgutil", "--pkg-info", XPipeInstallation.getPkgId()).redirectOutput(ProcessBuilder.Redirect.DISCARD).redirectError(ProcessBuilder.Redirect.DISCARD).start();
                process.waitFor();
                return process.exitValue() == 0;
            }
            catch (Exception ex) {
                return false;
            }
        }
        Path file = base.resolve("installation");
        return Files.exists(file, new LinkOption[0]);
    }

    public static Path getLocalDynamicLibraryDirectory() {
        Path path = XPipeInstallation.getCurrentInstallationBasePath();
        if (OsType.getLocal().equals(OsType.WINDOWS)) {
            return path.resolve("app").resolve("runtime").resolve("bin");
        }
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return path.resolve("app").resolve("lib").resolve("runtime").resolve("lib");
        }
        return path.resolve("Contents").resolve("runtime").resolve("Contents").resolve("Home").resolve("lib");
    }

    public static Path getLocalExtensionsDirectory(Path path) {
        return OsType.getLocal().equals(OsType.MACOS) ? path.resolve("Contents").resolve("Resources").resolve("extensions") : path.resolve("app").resolve("extensions");
    }

    private static Path getLocalInstallationBasePathForJavaExecutable(Path executable) {
        if (OsType.getLocal().equals(OsType.MACOS)) {
            return executable.getParent().getParent().getParent().getParent().getParent().getParent();
        }
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return executable.getParent().getParent().getParent().getParent().getParent();
        }
        return executable.getParent().getParent().getParent().getParent();
    }

    private static Path getLocalInstallationBasePathForDaemonExecutable(Path executable) {
        if (OsType.getLocal().equals(OsType.MACOS)) {
            return executable.getParent().getParent().getParent();
        }
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return executable.getParent().getParent().getParent();
        }
        return executable.getParent().getParent();
    }

    public static String getLocalInstallationBasePathForCLI(String cliExecutable) {
        String defaultInstallation = XPipeInstallation.getLocalDefaultInstallationBasePath();
        if (cliExecutable == null) {
            return defaultInstallation;
        }
        if (OsType.getLocal().equals(OsType.LINUX) && cliExecutable.equals("/usr/bin/xpipe")) {
            return defaultInstallation;
        }
        Path path = Path.of(cliExecutable, new String[0]);
        if (OsType.getLocal().equals(OsType.MACOS)) {
            return path.getParent().getParent().getParent().toString();
        }
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return path.getParent().getParent().getParent().toString();
        }
        return path.getParent().getParent().getParent().toString();
    }

    public static String queryLocalInstallationVersion(String exec) throws Exception {
        Process process = new ProcessBuilder(exec, "version").redirectError(ProcessBuilder.Redirect.DISCARD).start();
        String v = new String(process.getInputStream().readAllBytes(), StandardCharsets.US_ASCII);
        process.waitFor();
        return v;
    }

    public static Path getLocalBundledToolsDirectory() {
        Path path = XPipeInstallation.getCurrentInstallationBasePath();
        if (!ModuleHelper.isImage()) {
            if (OsType.getLocal().equals(OsType.WINDOWS)) {
                return path.resolve("dist").resolve("bundled_bin").resolve("windows");
            }
            if (OsType.getLocal().equals(OsType.LINUX)) {
                return path.resolve("dist").resolve("bundled_bin").resolve("linux");
            }
            return path.resolve("dist").resolve("bundled_bin").resolve("osx");
        }
        if (OsType.getLocal().equals(OsType.WINDOWS)) {
            return path.resolve("app").resolve("bundled");
        }
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return path.resolve("app").resolve("bundled");
        }
        return path.resolve("Contents").resolve("Resources").resolve("bundled");
    }

    public static String getLocalDefaultCliExecutable() {
        Path path = ModuleHelper.isImage() ? XPipeInstallation.getCurrentInstallationBasePath() : Path.of(XPipeInstallation.getLocalDefaultInstallationBasePath(), new String[0]);
        return path.resolve(XPipeInstallation.getRelativeCliExecutablePath(OsType.getLocal())).toString();
    }

    public static Path getLocalDefaultInstallationIcon() {
        Path path = XPipeInstallation.getCurrentInstallationBasePath();
        if (!ModuleHelper.isImage()) {
            if (OsType.getLocal().equals(OsType.WINDOWS)) {
                return path.resolve("dist").resolve("logo").resolve("logo.ico");
            }
            if (OsType.getLocal().equals(OsType.LINUX)) {
                return path.resolve("dist").resolve("logo").resolve("logo.png");
            }
            return path.resolve("dist").resolve("logo").resolve("logo.icns");
        }
        if (OsType.getLocal().equals(OsType.WINDOWS)) {
            return path.resolve("app").resolve("logo.ico");
        }
        if (OsType.getLocal().equals(OsType.LINUX)) {
            return path.resolve("logo.png");
        }
        return path.resolve("Contents").resolve("Resources").resolve("logo.icns");
    }

    public static String getLocalDefaultInstallationBasePath() {
        return XPipeInstallation.getLocalDefaultInstallationBasePath(staging);
    }

    public static String getLocalDefaultInstallationBasePath(boolean stage) {
        String path;
        if (OsType.getLocal().equals(OsType.WINDOWS)) {
            String base = System.getenv("LOCALAPPDATA");
            path = FileNames.join(base, stage ? "XPipe PTB" : "XPipe");
        } else {
            path = OsType.getLocal().equals(OsType.LINUX) ? (stage ? "/opt/xpipe-ptb" : "/opt/xpipe") : (stage ? "/Applications/XPipe PTB.app" : "/Applications/XPipe.app");
        }
        return path;
    }

    public static Path getLangPath() {
        if (!ModuleHelper.isImage()) {
            return XPipeInstallation.getCurrentInstallationBasePath().resolve("lang");
        }
        Path install = XPipeInstallation.getCurrentInstallationBasePath();
        OsType.Local type = OsType.getLocal();
        if (type.equals(OsType.WINDOWS)) {
            return install.resolve("app").resolve("lang");
        }
        if (type.equals(OsType.LINUX)) {
            return install.resolve("app").resolve("lang");
        }
        return install.resolve("Contents").resolve("Resources").resolve("lang");
    }

    public static Path getBundledFontsPath() {
        if (!ModuleHelper.isImage()) {
            return Path.of("dist", "fonts");
        }
        Path install = XPipeInstallation.getCurrentInstallationBasePath();
        OsType.Local type = OsType.getLocal();
        if (type.equals(OsType.WINDOWS)) {
            return install.resolve("app").resolve("fonts");
        }
        if (type.equals(OsType.LINUX)) {
            return install.resolve("app").resolve("fonts");
        }
        return install.resolve("Contents").resolve("Resources").resolve("fonts");
    }

    public static String getDaemonDebugScriptPath(OsType.Local type) {
        if (type.equals(OsType.WINDOWS)) {
            return FileNames.join("app", "scripts", "xpiped_debug.bat");
        }
        if (type.equals(OsType.LINUX)) {
            return FileNames.join("app", "scripts", "xpiped_debug.sh");
        }
        return FileNames.join("Contents", "Resources", "scripts", "xpiped_debug.sh");
    }

    public static String getDaemonDebugAttachScriptPath(OsType.Local type) {
        if (type.equals(OsType.WINDOWS)) {
            return FileNames.join("app", "scripts", "xpiped_debug_attach.bat");
        }
        if (type.equals(OsType.LINUX)) {
            return FileNames.join("app", "scripts", "xpiped_debug_attach.sh");
        }
        return FileNames.join("Contents", "Resources", "scripts", "xpiped_debug_attach.sh");
    }

    public static String getDaemonExecutablePath(OsType.Local type) {
        if (type.equals(OsType.WINDOWS)) {
            return FileNames.join("app", "xpiped.exe");
        }
        if (type.equals(OsType.LINUX)) {
            return FileNames.join("app", "bin", "xpiped");
        }
        return FileNames.join("Contents", "MacOS", "xpiped");
    }

    public static String getRelativeCliExecutablePath(OsType.Local type) {
        if (type.equals(OsType.WINDOWS)) {
            return FileNames.join("cli", "bin", "xpipe.exe");
        }
        if (type.equals(OsType.LINUX)) {
            return FileNames.join("cli", "bin", "xpipe");
        }
        return FileNames.join("Contents", "MacOS", "xpipe");
    }

    public static boolean isStaging() {
        return staging;
    }
}

