/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public enum XPipeDaemonMode {
    BACKGROUND("background", List.of("base", "background")),
    TRAY("tray", List.of("tray", "taskbar")),
    GUI("gui", List.of("gui", "desktop", "interface"));

    private final String displayName;
    private final List<String> nameAlternatives;

    private XPipeDaemonMode(String displayName, List<String> nameAlternatives) {
        this.displayName = displayName;
        this.nameAlternatives = nameAlternatives;
    }

    public static XPipeDaemonMode get(String name) {
        return Arrays.stream(XPipeDaemonMode.values()).filter(xPipeDaemonMode -> xPipeDaemonMode.getNameAlternatives().contains(name.toLowerCase(Locale.ROOT))).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown mode: " + name + ". Possible values: " + Arrays.stream(XPipeDaemonMode.values()).map(XPipeDaemonMode::getDisplayName).collect(Collectors.joining(", "))));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getNameAlternatives() {
        return this.nameAlternatives;
    }
}

