/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import java.util.ServiceLoader;
import java.util.function.Consumer;

public interface ModuleLayerLoader {
    public static void loadAll(ModuleLayer layer, Consumer<Throwable> errorHandler) {
        ServiceLoader<ModuleLayerLoader> loaded = layer != null ? ServiceLoader.load(layer, ModuleLayerLoader.class) : ServiceLoader.load(ModuleLayerLoader.class);
        loaded.stream().forEach(moduleLayerLoaderProvider -> {
            ModuleLayerLoader instance = (ModuleLayerLoader)moduleLayerLoaderProvider.get();
            try {
                instance.init(layer);
            }
            catch (Throwable t) {
                errorHandler.accept(t);
            }
        });
    }

    default public void init(ModuleLayer layer) {
    }

    default public void reset() {
    }
}

