/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.xpipe.core.util.AesSecretValue;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import javax.crypto.SecretKey;

@JsonTypeName(value="default")
@JsonDeserialize(builder=InPlaceSecretValueBuilderImpl.class)
public class InPlaceSecretValue
extends AesSecretValue {
    public InPlaceSecretValue(char[] secret) {
        super(secret);
    }

    public static InPlaceSecretValue of(String s) {
        return new InPlaceSecretValue(s.toCharArray());
    }

    public static InPlaceSecretValue of(char[] c) {
        return new InPlaceSecretValue(c);
    }

    @Override
    protected int getIterationCount() {
        return 2048;
    }

    @Override
    protected byte[] getNonce(int numBytes) {
        byte[] nonce = new byte[numBytes];
        new Random(213186L).nextBytes(nonce);
        return nonce;
    }

    @Override
    protected SecretKey getAESKey() throws InvalidKeySpecException {
        return this.getSecretKey(new char[]{'X', 'P', '\u008a'});
    }

    @Override
    public InPlaceSecretValue inPlace() {
        return this;
    }

    @Override
    public String toString() {
        return "<in place secret>";
    }

    protected InPlaceSecretValue(InPlaceSecretValueBuilder<?, ?> b) {
        super((AesSecretValue.AesSecretValueBuilder<?, ?>)b);
    }

    public static InPlaceSecretValueBuilder<?, ?> builder() {
        return new InPlaceSecretValueBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InPlaceSecretValue)) {
            return false;
        }
        InPlaceSecretValue other = (InPlaceSecretValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InPlaceSecretValue;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @JsonTypeName(value="default")
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class InPlaceSecretValueBuilderImpl
    extends InPlaceSecretValueBuilder<InPlaceSecretValue, InPlaceSecretValueBuilderImpl> {
        private InPlaceSecretValueBuilderImpl() {
        }

        @Override
        protected InPlaceSecretValueBuilderImpl self() {
            return this;
        }

        @Override
        public InPlaceSecretValue build() {
            return new InPlaceSecretValue(this);
        }
    }

    public static abstract class InPlaceSecretValueBuilder<C extends InPlaceSecretValue, B extends InPlaceSecretValueBuilder<C, B>>
    extends AesSecretValue.AesSecretValueBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "InPlaceSecretValue.InPlaceSecretValueBuilder(super=" + super.toString() + ")";
        }
    }
}

