/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.util;

import io.xpipe.core.util.EncryptedSecretValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AesSecretValue
extends EncryptedSecretValue {
    private static final String ENCRYPT_ALGO = "AES/GCM/NoPadding";
    private static final int TAG_LENGTH_BIT = 128;
    private static final int IV_LENGTH_BYTE = 12;
    private static final int AES_KEY_BIT = 128;
    private static final int SALT_BIT = 16;
    private static final SecretKeyFactory SECRET_FACTORY;

    public AesSecretValue(char[] secret) {
        super(secret);
    }

    protected abstract int getIterationCount();

    protected byte[] getNonce(int numBytes) {
        byte[] nonce = new byte[numBytes];
        new SecureRandom().nextBytes(nonce);
        return nonce;
    }

    protected SecretKey getSecretKey(char[] chars) throws InvalidKeySpecException {
        byte[] salt = new byte[16];
        new Random(128L).nextBytes(salt);
        PBEKeySpec spec = new PBEKeySpec(chars, salt, this.getIterationCount(), 128);
        return new SecretKeySpec(SECRET_FACTORY.generateSecret(spec).getEncoded(), "AES");
    }

    protected SecretKey getAESKey() throws InvalidKeySpecException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] encrypt(byte[] c) {
        SecretKey secretKey = this.getAESKey();
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);
        byte[] iv = this.getNonce(12);
        cipher.init(1, (Key)secretKey, new GCMParameterSpec(128, iv));
        byte[] bytes = cipher.doFinal(c);
        bytes = ByteBuffer.allocate(iv.length + bytes.length).order(ByteOrder.LITTLE_ENDIAN).put(iv).put(bytes).array();
        return bytes;
    }

    @Override
    public byte[] decrypt(byte[] c) {
        ByteBuffer bb = ByteBuffer.wrap(c).order(ByteOrder.LITTLE_ENDIAN);
        byte[] iv = new byte[12];
        bb.get(iv);
        byte[] cipherText = new byte[bb.remaining()];
        bb.get(cipherText);
        SecretKey secretKey = this.getAESKey();
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);
        cipher.init(2, (Key)secretKey, new GCMParameterSpec(128, iv));
        return cipher.doFinal(cipherText);
    }

    protected AesSecretValue(AesSecretValueBuilder<?, ?> b) {
        super(b);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AesSecretValue)) {
            return false;
        }
        AesSecretValue other = (AesSecretValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AesSecretValue;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    static {
        try {
            SECRET_FACTORY = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static abstract class AesSecretValueBuilder<C extends AesSecretValue, B extends AesSecretValueBuilder<C, B>>
    extends EncryptedSecretValue.EncryptedSecretValueBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "AesSecretValue.AesSecretValueBuilder(super=" + super.toString() + ")";
        }
    }
}

