/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.store.DataStore;
import io.xpipe.core.store.DataStoreState;
import io.xpipe.core.util.DataStateProvider;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;

public interface StatefulDataStore<T extends DataStoreState>
extends DataStore {
    default public T createDefaultState() {
        Method c = this.getStateClass().getDeclaredMethod("builder", new Class[0]);
        c.setAccessible(true);
        Object b = c.invoke(null, new Object[0]);
        Method m = b.getClass().getDeclaredMethod("build", new Class[0]);
        m.setAccessible(true);
        return (T)((DataStoreState)this.getStateClass().cast(m.invoke(b, new Object[0])));
    }

    default public T getState() {
        return (T)DataStateProvider.get().getState(this, this::createDefaultState);
    }

    default public void setState(T val) {
        DataStateProvider.get().setState(this, (DataStoreState)val);
    }

    default public Class<T> getStateClass() {
        Optional<Class> found = Arrays.stream(this.getClass().getDeclaredClasses()).filter(aClass -> DataStoreState.class.isAssignableFrom((Class<?>)aClass)).findAny();
        if (found.isEmpty()) {
            throw new IllegalArgumentException("Store class " + this.getClass().getSimpleName() + " does not have a state class set");
        }
        return found.get();
    }
}

