/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.process.ProcessControl;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.store.ConnectionFileSystem;
import io.xpipe.core.store.DataStore;
import io.xpipe.core.store.FileSystem;
import io.xpipe.core.store.FileSystemStore;
import io.xpipe.core.store.LaunchableStore;
import io.xpipe.core.store.LocalStore;
import io.xpipe.core.store.ValidatableStore;

public interface ShellStore
extends DataStore,
LaunchableStore,
FileSystemStore,
ValidatableStore {
    public static boolean isLocal(ShellStore s) {
        return s instanceof LocalStore;
    }

    @Override
    default public FileSystem createFileSystem() {
        return new ConnectionFileSystem(this.control());
    }

    default public ProcessControl prepareLaunchCommand() {
        return this.control();
    }

    public ShellControl control();

    @Override
    default public void validate() throws Exception {
        ShellControl pc;
        ShellControl c = this.control();
        if (!this.isInStorage()) {
            c.withoutLicenseCheck();
        }
        if ((pc = c.start()) != null) {
            pc.close();
        }
    }
}

