/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.process.ShellControl;
import io.xpipe.core.store.NetworkTunnelSession;
import io.xpipe.core.store.Session;
import io.xpipe.core.store.SessionListener;
import java.util.List;

public class SessionChain
extends NetworkTunnelSession {
    private final List<NetworkTunnelSession> sessions;
    private int runningCounter;

    public SessionChain(SessionListener listener, List<NetworkTunnelSession> sessions) {
        super(listener);
        this.sessions = sessions;
        sessions.forEach(session -> session.addListener(running -> this.runningCounter += running ? 1 : -1));
    }

    @Override
    public ShellControl getShellControl() {
        return this.sessions.getLast().getShellControl();
    }

    @Override
    public int getLocalPort() {
        return this.sessions.getFirst().getLocalPort();
    }

    @Override
    public int getRemotePort() {
        return this.sessions.getLast().getRemotePort();
    }

    @Override
    public boolean isRunning() {
        return this.sessions.stream().allMatch(session -> session.isRunning());
    }

    @Override
    public void start() throws Exception {
        for (Session session : this.sessions) {
            session.start();
        }
    }

    @Override
    public void stop() throws Exception {
        for (Session session : this.sessions) {
            session.stop();
        }
    }
}

