/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.process.ShellControl;
import io.xpipe.core.store.DataStore;
import io.xpipe.core.store.NetworkTunnelSession;
import io.xpipe.core.store.SessionChain;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public interface NetworkTunnelStore
extends DataStore {
    public static final AtomicInteger portCounter = new AtomicInteger();

    public static int randomPort() {
        int p = 40000 + portCounter.get();
        portCounter.set(portCounter.get() + 1);
        return p;
    }

    public DataStore getNetworkParent();

    default public boolean requiresTunnel() {
        NetworkTunnelStore current = this;
        while (true) {
            NetworkTunnelStore t;
            TunnelFunction func;
            if ((func = current.tunnelSession()) != null) {
                return true;
            }
            if (current.getNetworkParent() == null) {
                return false;
            }
            DataStore dataStore = current.getNetworkParent();
            if (!(dataStore instanceof NetworkTunnelStore)) break;
            current = t = (NetworkTunnelStore)dataStore;
        }
        return false;
    }

    default public boolean isLocallyTunneable() {
        NetworkTunnelStore current = this;
        while (true) {
            NetworkTunnelStore t;
            if (current.getNetworkParent() == null) {
                return true;
            }
            DataStore dataStore = current.getNetworkParent();
            if (!(dataStore instanceof NetworkTunnelStore)) break;
            current = t = (NetworkTunnelStore)dataStore;
        }
        return false;
    }

    default public NetworkTunnelSession sessionChain(int local, final int remotePort) throws Exception {
        if (!this.isLocallyTunneable()) {
            throw new IllegalStateException("Unable to create tunnel chain as one intermediate system does not support tunneling");
        }
        AtomicBoolean running = new AtomicBoolean();
        AtomicInteger runningCounter = new AtomicInteger();
        AtomicInteger counter = new AtomicInteger();
        ArrayList<NetworkTunnelSession> sessions = new ArrayList<NetworkTunnelSession>();
        NetworkTunnelStore current = this;
        do {
            TunnelFunction func;
            if ((func = current.tunnelSession()) == null) continue;
            int currentLocalPort = this.isLast(current) ? local : NetworkTunnelStore.randomPort();
            int currentRemotePort = sessions.isEmpty() ? remotePort : ((NetworkTunnelSession)sessions.getLast()).getLocalPort();
            NetworkTunnelSession t = func.create(currentLocalPort, currentRemotePort);
            t.addListener(r -> {
                if (r) {
                    runningCounter.incrementAndGet();
                } else {
                    runningCounter.decrementAndGet();
                }
                running.set(runningCounter.get() == counter.get());
            });
            t.start();
            sessions.add(t);
            counter.incrementAndGet();
        } while ((current = (NetworkTunnelStore)current.getNetworkParent()) != null);
        if (sessions.size() == 1) {
            return (NetworkTunnelSession)sessions.getFirst();
        }
        if (sessions.isEmpty()) {
            return new NetworkTunnelSession(this, null){

                @Override
                public boolean isRunning() {
                    return false;
                }

                @Override
                public void start() {
                }

                @Override
                public void stop() {
                }

                @Override
                public int getLocalPort() {
                    return remotePort;
                }

                @Override
                public int getRemotePort() {
                    return remotePort;
                }

                @Override
                public ShellControl getShellControl() {
                    return null;
                }
            };
        }
        return new SessionChain(running1 -> {}, sessions);
    }

    default public boolean isLast(NetworkTunnelStore tunnelStore) {
        NetworkTunnelStore current = tunnelStore;
        while ((current = (NetworkTunnelStore)current.getNetworkParent()) != null) {
            TunnelFunction func = current.tunnelSession();
            if (func == null) continue;
            return false;
        }
        return true;
    }

    default public TunnelFunction tunnelSession() {
        return null;
    }

    public static interface TunnelFunction {
        public NetworkTunnelSession create(int var1, int var2);
    }
}

