/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.process.ShellControl;
import io.xpipe.core.store.FileKind;
import io.xpipe.core.store.FileNames;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;

public interface FileSystem
extends Closeable,
AutoCloseable {
    public long getFileSize(String var1) throws Exception;

    public Optional<ShellControl> getShell();

    public FileSystem open() throws Exception;

    public InputStream openInput(String var1) throws Exception;

    public OutputStream openOutput(String var1, long var2) throws Exception;

    public boolean fileExists(String var1) throws Exception;

    public void delete(String var1) throws Exception;

    public void copy(String var1, String var2) throws Exception;

    public void move(String var1, String var2) throws Exception;

    public void mkdirs(String var1) throws Exception;

    public void touch(String var1) throws Exception;

    public void symbolicLink(String var1, String var2) throws Exception;

    public boolean directoryExists(String var1) throws Exception;

    public void directoryAccessible(String var1) throws Exception;

    public Stream<FileEntry> listFiles(String var1) throws Exception;

    default public List<FileEntry> listFilesRecursively(String file) throws Exception {
        List<FileEntry> base;
        try (Stream<FileEntry> filesStream = this.listFiles(file);){
            base = filesStream.toList();
        }
        return base.stream().flatMap(fileEntry -> {
            if (fileEntry.getKind() != FileKind.DIRECTORY) {
                return Stream.of(fileEntry);
            }
            try {
                ArrayList<FileEntry> list = new ArrayList<FileEntry>();
                list.add((FileEntry)fileEntry);
                list.addAll(this.listFilesRecursively(fileEntry.getPath()));
                return list.stream();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).toList();
    }

    public List<String> listRoots() throws Exception;

    public static class FileEntry {
        private final FileSystem fileSystem;
        private final Instant date;
        private final boolean hidden;
        private final Boolean executable;
        private final long size;
        private final String mode;
        @NonNull
        private final FileKind kind;
        @NonNull
        private String path;
        private String extension;
        private String name;

        public FileEntry(FileSystem fileSystem, @NonNull String path, Instant date, boolean hidden, Boolean executable, long size, String mode, @NonNull FileKind kind) {
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            if (kind == null) {
                throw new NullPointerException("kind is marked non-null but is null");
            }
            this.fileSystem = fileSystem;
            this.mode = mode;
            this.kind = kind;
            this.path = kind == FileKind.DIRECTORY ? FileNames.toDirectory(path) : path;
            this.extension = FileNames.getExtension(path);
            this.name = FileNames.getFileName(path);
            this.date = date;
            this.hidden = hidden;
            this.executable = executable;
            this.size = size;
        }

        public static FileEntry ofDirectory(FileSystem fileSystem, String path) {
            return new FileEntry(fileSystem, path, Instant.now(), true, false, 0L, null, FileKind.DIRECTORY);
        }

        public void setPath(String path) {
            this.path = path;
            this.extension = FileNames.getExtension(path);
            this.name = FileNames.getFileName(path);
        }

        public FileEntry resolved() {
            return this;
        }

        public FileSystem getFileSystem() {
            return this.fileSystem;
        }

        public Instant getDate() {
            return this.date;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public Boolean getExecutable() {
            return this.executable;
        }

        public long getSize() {
            return this.size;
        }

        public String getMode() {
            return this.mode;
        }

        @NonNull
        public FileKind getKind() {
            return this.kind;
        }

        @NonNull
        public String getPath() {
            return this.path;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileEntry)) {
                return false;
            }
            FileEntry other = (FileEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isHidden() != other.isHidden()) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            Boolean this$executable = this.getExecutable();
            Boolean other$executable = other.getExecutable();
            if (this$executable == null ? other$executable != null : !((Object)this$executable).equals(other$executable)) {
                return false;
            }
            FileSystem this$fileSystem = this.getFileSystem();
            FileSystem other$fileSystem = other.getFileSystem();
            if (this$fileSystem == null ? other$fileSystem != null : !this$fileSystem.equals(other$fileSystem)) {
                return false;
            }
            Instant this$date = this.getDate();
            Instant other$date = other.getDate();
            if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
                return false;
            }
            String this$mode = this.getMode();
            String other$mode = other.getMode();
            if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
                return false;
            }
            FileKind this$kind = this.getKind();
            FileKind other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$extension = this.getExtension();
            String other$extension = other.getExtension();
            if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isHidden() ? 79 : 97);
            long $size = this.getSize();
            result = result * 59 + (int)($size >>> 32 ^ $size);
            Boolean $executable = this.getExecutable();
            result = result * 59 + ($executable == null ? 43 : ((Object)$executable).hashCode());
            FileSystem $fileSystem = this.getFileSystem();
            result = result * 59 + ($fileSystem == null ? 43 : $fileSystem.hashCode());
            Instant $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
            String $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
            FileKind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $extension = this.getExtension();
            result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "FileSystem.FileEntry(fileSystem=" + String.valueOf(this.getFileSystem()) + ", date=" + String.valueOf(this.getDate()) + ", hidden=" + this.isHidden() + ", executable=" + this.getExecutable() + ", size=" + this.getSize() + ", mode=" + this.getMode() + ", kind=" + String.valueOf((Object)this.getKind()) + ", path=" + this.getPath() + ", extension=" + this.getExtension() + ", name=" + this.getName() + ")";
        }
    }

    public static final class LinkFileEntry
    extends FileEntry {
        @NonNull
        private final FileEntry target;

        public LinkFileEntry(@NonNull FileSystem fileSystem, @NonNull String path, Instant date, boolean hidden, Boolean executable, long size, String mode, @NonNull FileEntry target) {
            super(fileSystem, path, date, hidden, executable, size, mode, FileKind.LINK);
            if (fileSystem == null) {
                throw new NullPointerException("fileSystem is marked non-null but is null");
            }
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            this.target = target;
        }

        @Override
        public FileEntry resolved() {
            return this.target;
        }

        @NonNull
        public FileEntry getTarget() {
            return this.target;
        }

        @Override
        public String toString() {
            return "FileSystem.LinkFileEntry(target=" + String.valueOf(this.getTarget()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LinkFileEntry)) {
                return false;
            }
            LinkFileEntry other = (LinkFileEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FileEntry this$target = this.getTarget();
            FileEntry other$target = other.getTarget();
            return !(this$target == null ? other$target != null : !((Object)this$target).equals(other$target));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof LinkFileEntry;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            FileEntry $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
            return result;
        }
    }
}

