/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import io.xpipe.core.process.OsType;
import io.xpipe.core.store.FileNames;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;

public final class FilePath {
    @NonNull
    private final String value;

    public static boolean isProbableFilePath(OsType osType, String s) {
        if (osType.equals(OsType.WINDOWS) && s.length() >= 2 && s.charAt(1) == ':') {
            return true;
        }
        return s.startsWith("/");
    }

    public FilePath(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.value = value;
        if (value.isBlank()) {
            throw new IllegalArgumentException();
        }
        if (!value.equals(value.trim())) {
            throw new IllegalArgumentException();
        }
    }

    public FilePath fileSystemCompatible(OsType osType) {
        List<String> split = this.split();
        boolean needsReplacement = split.stream().anyMatch(s -> !s.equals(osType.makeFileSystemCompatible((String)s)));
        if (!needsReplacement) {
            return this;
        }
        Pattern p = Pattern.compile("[^/\\\\]+");
        Matcher m = p.matcher(this.value);
        String replaced = m.replaceAll(matchResult -> osType.makeFileSystemCompatible(matchResult.group()));
        return new FilePath(replaced);
    }

    public FilePath getRoot() {
        List<String> split;
        if (this.value.startsWith("/")) {
            return new FilePath("/");
        }
        if (this.value.length() >= 2 && this.value.charAt(1) == ':') {
            return new FilePath(this.value.substring(0, 2) + "\\");
        }
        if (this.value.startsWith("\\\\") && (split = this.split()).size() > 0) {
            return new FilePath("\\\\" + split.getFirst());
        }
        throw new IllegalArgumentException("Unable to determine root of " + this.value);
    }

    public Path toLocalPath() {
        return Path.of(this.value, new String[0]);
    }

    public String toString() {
        return this.value;
    }

    public String quoteIfNecessary() {
        return this.value.contains(" ") ? "\"" + this.value + "\"" : this.value;
    }

    public FilePath toDirectory() {
        if (this.value.endsWith("/") || this.value.endsWith("\\")) {
            return new FilePath(this.value);
        }
        if (this.value.contains("\\")) {
            return new FilePath(this.value + "\\");
        }
        return new FilePath(this.value + "/");
    }

    public FilePath removeTrailingSlash() {
        if (this.value.equals("/")) {
            return new FilePath(this.value);
        }
        if (this.value.endsWith("/") || this.value.endsWith("\\")) {
            return new FilePath(this.value.substring(0, this.value.length() - 1));
        }
        return new FilePath(this.value);
    }

    public String getFileName() {
        String[] split = this.value.split("[\\\\/]");
        if (split.length == 0) {
            return "";
        }
        List<String> components = Arrays.stream(split).filter(s -> !s.isEmpty()).toList();
        if (components.size() == 0) {
            return "";
        }
        return components.getLast();
    }

    public List<String> splitHierarchy() {
        String f = this.value + "/";
        ArrayList<String> list = new ArrayList<String>();
        int lastElementStart = 0;
        for (int i = 0; i < f.length(); ++i) {
            if (f.charAt(i) != '\\' && f.charAt(i) != '/') continue;
            if (i - lastElementStart > 0) {
                list.add(f.substring(0, i));
            }
            lastElementStart = i + 1;
        }
        return list;
    }

    public String getBaseName() {
        int split = this.value.lastIndexOf(".");
        if (split == -1) {
            return this.value;
        }
        return this.value.substring(0, split);
    }

    public String getExtension() {
        String name = FileNames.getFileName(this.value);
        String[] split = name.split("\\.");
        if (split.length == 0) {
            return null;
        }
        return split[split.length - 1];
    }

    public FilePath join(String ... parts) {
        String joined = String.join((CharSequence)"/", parts);
        return new FilePath(this.value + "/" + joined).normalize();
    }

    public boolean isAbsolute() {
        if (!this.value.contains("/") && !this.value.contains("\\")) {
            return false;
        }
        return this.value.startsWith("\\") || this.value.startsWith("/") || this.value.startsWith("~") || this.value.matches("^\\w:.*");
    }

    public FilePath getParent() {
        if (this.split().size() == 0) {
            return null;
        }
        if (this.split().size() == 1) {
            return this.value.startsWith("/") && !this.value.equals("/") ? new FilePath("/") : null;
        }
        return new FilePath(this.value.substring(0, this.value.length() - this.getFileName().length() - 1));
    }

    public boolean startsWith(FilePath start) {
        return this.normalize().startsWith(start.normalize());
    }

    public FilePath relativize(FilePath base) {
        return new FilePath(this.normalize().toString().substring(base.normalize().toDirectory().toString().length()));
    }

    public FilePath normalize() {
        boolean backslash = this.value.contains("\\");
        return new FilePath(backslash ? this.toWindows() : this.toUnix());
    }

    private List<String> split() {
        String[] split = this.value.split("[\\\\/]");
        return Arrays.stream(split).filter(s -> !s.isEmpty()).toList();
    }

    public String toUnix() {
        String joined = String.join((CharSequence)"/", this.split());
        String prefix = this.value.startsWith("/") ? "/" : "";
        String suffix = this.value.endsWith("/") || this.value.endsWith("\\") ? "/" : "";
        return prefix + joined + suffix;
    }

    public String toWindows() {
        String suffix = this.value.endsWith("/") || this.value.endsWith("\\") ? "\\" : "";
        return String.join((CharSequence)"\\", this.split()) + suffix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilePath)) {
            return false;
        }
        FilePath other = (FilePath)o;
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

