/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.store;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.xpipe.core.process.CommandBuilder;
import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.store.FileSystem;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class ConnectionFileSystem
implements FileSystem {
    @JsonIgnore
    protected final ShellControl shellControl;

    public ConnectionFileSystem(ShellControl shellControl) {
        this.shellControl = shellControl;
    }

    @Override
    public long getFileSize(String file) throws Exception {
        return Long.parseLong(this.shellControl.getShellDialect().queryFileSize(this.shellControl, file).readStdoutOrThrow());
    }

    @Override
    public Optional<ShellControl> getShell() {
        return Optional.of(this.shellControl);
    }

    @Override
    public FileSystem open() throws Exception {
        this.shellControl.start();
        if (!this.shellControl.getShellDialect().getDumbMode().supportsAnyPossibleInteraction()) {
            this.shellControl.close();
            throw new UnsupportedOperationException("System shell does not support file system interaction");
        }
        return this;
    }

    @Override
    public InputStream openInput(String file) throws Exception {
        return this.shellControl.getShellDialect().getFileReadCommand(this.shellControl, file).startExternalStdout();
    }

    @Override
    public OutputStream openOutput(String file, long totalBytes) throws Exception {
        CommandControl cmd = this.shellControl.getShellDialect().createStreamFileWriteCommand(this.shellControl, file, totalBytes);
        cmd.setExitTimeout(Duration.ofMillis(Long.MAX_VALUE));
        return cmd.startExternalStdin();
    }

    @Override
    public boolean fileExists(String file) throws Exception {
        try (CommandControl pc = this.shellControl.getShellDialect().createFileExistsCommand(this.shellControl, file).start();){
            boolean bl = pc.discardAndCheckExit();
            return bl;
        }
    }

    @Override
    public void delete(String file) throws Exception {
        try (CommandControl pc = this.shellControl.getShellDialect().deleteFileOrDirectory(this.shellControl, file).start();){
            pc.discardOrThrow();
        }
    }

    @Override
    public void copy(String file, String newFile) throws Exception {
        try (CommandControl pc = this.shellControl.getShellDialect().getFileCopyCommand(this.shellControl, file, newFile).start();){
            pc.discardOrThrow();
        }
    }

    @Override
    public void move(String file, String newFile) throws Exception {
        try (CommandControl pc = this.shellControl.getShellDialect().getFileMoveCommand(this.shellControl, file, newFile).start();){
            pc.discardOrThrow();
        }
    }

    @Override
    public void mkdirs(String file) throws Exception {
        try (CommandControl pc = this.shellControl.command(CommandBuilder.ofFunction(proc -> proc.getShellDialect().getMkdirsCommand(file))).start();){
            pc.discardOrThrow();
        }
    }

    @Override
    public void touch(String file) throws Exception {
        try (CommandControl pc = this.shellControl.getShellDialect().getFileTouchCommand(this.shellControl, file).start();){
            pc.discardOrThrow();
        }
    }

    @Override
    public void symbolicLink(String linkFile, String targetFile) throws Exception {
        try (CommandControl pc = this.shellControl.getShellDialect().symbolicLink(this.shellControl, linkFile, targetFile).start();){
            pc.discardOrThrow();
        }
    }

    @Override
    public boolean directoryExists(String file) throws Exception {
        return this.shellControl.getShellDialect().directoryExists(this.shellControl, file).executeAndCheck();
    }

    @Override
    public void directoryAccessible(String file) throws Exception {
        this.shellControl.executeSimpleCommand(this.shellControl.getShellDialect().getCdCommand(file));
    }

    @Override
    public Stream<FileSystem.FileEntry> listFiles(String file) throws Exception {
        return this.shellControl.getShellDialect().listFiles(this, this.shellControl, file);
    }

    @Override
    public List<String> listRoots() throws Exception {
        return this.shellControl.getShellDialect().listRoots(this.shellControl).toList();
    }

    @Override
    public void close() {
        try {
            this.shellControl.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ShellControl getShellControl() {
        return this.shellControl;
    }
}

