/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.CommandBuilder;
import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.process.ShellDialectAskpass;
import io.xpipe.core.process.ShellDumbMode;
import io.xpipe.core.process.ShellLaunchCommand;
import io.xpipe.core.store.FilePath;
import io.xpipe.core.store.FileSystem;
import io.xpipe.core.util.NewLine;
import io.xpipe.core.util.SecretValue;
import io.xpipe.core.util.StreamCharset;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;

public interface ShellDialect {
    public CommandBuilder launchAsnyc(CommandBuilder var1);

    default public String getLicenseFeatureId() {
        return null;
    }

    public String terminalLauncherScript(UUID var1, String var2);

    public String getExecutableName();

    default public boolean isSelectable() {
        return true;
    }

    default public boolean isCompatibleTo(ShellDialect other) {
        return other.equals(this);
    }

    public String getCatchAllVariable();

    public String queryVersion(ShellControl var1) throws Exception;

    public CommandControl queryFileSize(ShellControl var1, String var2);

    public CommandControl prepareUserTempDirectory(ShellControl var1, String var2);

    public String initFileName(ShellControl var1) throws Exception;

    public CommandControl directoryExists(ShellControl var1, String var2);

    public CommandControl evaluateExpression(ShellControl var1, String var2);

    public CommandControl resolveDirectory(ShellControl var1, String var2);

    public String literalArgument(String var1);

    public String fileArgument(String var1);

    default public String fileArgument(FilePath s) {
        return this.fileArgument(s.toString());
    }

    public String quoteArgument(String var1);

    public String prepareTerminalEnvironmentCommands();

    public String addToPathVariableCommand(List<String> var1, boolean var2);

    default public String applyInitFileCommand() {
        return null;
    }

    public String changeTitleCommand(String var1);

    public CommandControl createStreamFileWriteCommand(ShellControl var1, String var2, long var3);

    default public String getCdCommand(String directory) {
        return "cd \"" + directory + "\"";
    }

    public String getScriptFileEnding();

    public String assembleCommand(String var1, Map<String, String> var2);

    public Stream<FileSystem.FileEntry> listFiles(FileSystem var1, ShellControl var2, String var3) throws Exception;

    public Stream<String> listRoots(ShellControl var1) throws Exception;

    public String getPauseCommand();

    public String prepareScriptContent(String var1);

    default public String getPassthroughExitCommand() {
        return "exit";
    }

    default public String getNormalExitCommand() {
        return "exit 0";
    }

    public String environmentVariable(String var1);

    default public String getConcatenationOperator() {
        return ";";
    }

    public String getDiscardOperator();

    public String nullStdin(String var1);

    public String getScriptPermissionsCommand(String var1);

    public ShellDialectAskpass getAskpass();

    public String getSetEnvironmentVariableCommand(String var1, String var2);

    public String setSecretEnvironmentVariableCommand(ShellControl var1, String var2, SecretValue var3) throws Exception;

    public String getEchoCommand(String var1, boolean var2);

    public String getPrintVariableCommand(String var1);

    public CommandControl printUsernameCommand(ShellControl var1);

    public String getPrintExitCodeCommand(String var1, String var2);

    public int assignMissingExitCode();

    default public String getPrintEnvironmentVariableCommand(String name) {
        return this.getPrintVariableCommand(name);
    }

    public CommandBuilder getOpenScriptCommand(String var1);

    default public void prepareCommandForShell(CommandBuilder b) {
    }

    public String prepareTerminalInitFileOpenCommand(ShellDialect var1, ShellControl var2, String var3);

    public String runScriptCommand(ShellControl var1, String var2);

    public String sourceScriptCommand(ShellControl var1, String var2);

    public String executeCommandWithShell(String var1);

    public String getMkdirsCommand(String var1);

    public CommandControl getFileReadCommand(ShellControl var1, String var2);

    public String getPrintWorkingDirectoryCommand();

    public StreamCharset getScriptCharset();

    public CommandControl getFileCopyCommand(ShellControl var1, String var2, String var3);

    public CommandControl getFileMoveCommand(ShellControl var1, String var2, String var3);

    default public boolean requiresScript(String content) {
        return content.contains("\n");
    }

    public CommandControl createTextFileWriteCommand(ShellControl var1, String var2, String var3);

    public CommandControl createScriptTextFileWriteCommand(ShellControl var1, String var2, String var3);

    public CommandControl deleteFileOrDirectory(ShellControl var1, String var2);

    public String clearDisplayCommand();

    public ShellLaunchCommand getLaunchCommand();

    public ShellDumbMode getDumbMode();

    public CommandControl createFileExistsCommand(ShellControl var1, String var2);

    public CommandControl symbolicLink(ShellControl var1, String var2, String var3);

    public CommandControl getFileDeleteCommand(ShellControl var1, String var2);

    public CommandControl getFileTouchCommand(ShellControl var1, String var2);

    public String getWhichCommand(String var1);

    public Charset determineCharset(ShellControl var1);

    public NewLine getNewLine();

    public String getId();

    public String getDisplayName();

    public boolean doesEchoInput();
}

