/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import java.util.Arrays;
import java.util.stream.Collectors;

public class ProcessOutputException
extends Exception {
    private final long exitCode;
    private final String output;

    private ProcessOutputException(String message, long exitCode, String output) {
        super(message);
        this.exitCode = exitCode;
        this.output = output;
    }

    public static ProcessOutputException withParagraph(String customPrefix, ProcessOutputException ex) {
        String messageSuffix = ex.getOutput() != null ? ex.getOutput() : "";
        String message = customPrefix + "\n\n" + messageSuffix;
        return new ProcessOutputException(message, ex.getExitCode(), ex.getOutput());
    }

    public static ProcessOutputException withPrefix(String customPrefix, ProcessOutputException ex) {
        String messageSuffix = ex.getOutput() != null && !ex.getOutput().isBlank() ? ":\n" + ex.getOutput() : "";
        String message = customPrefix + messageSuffix;
        return new ProcessOutputException(message, ex.getExitCode(), ex.getOutput());
    }

    public static ProcessOutputException of(long exitCode, String ... messages) {
        String combinedError = Arrays.stream(messages).filter(s -> s != null && !s.isBlank()).map(s -> s.strip()).collect(Collectors.joining("\n\n")).replaceAll("\r\n", "\n");
        boolean hasMessage = !combinedError.isBlank();
        Object errorSuffix = hasMessage ? ":\n" + combinedError : "";
        String message = switch ((int)exitCode) {
            case 162 -> "Process did not start up properly and had to be killed" + (String)errorSuffix;
            case 161 -> "Wait for process exit timed out" + (String)errorSuffix;
            case 160 -> "Process exited with unknown state. Did an external process interfere?" + (String)errorSuffix;
            case 163 -> "Process execution failed" + (String)errorSuffix;
            case 164 -> "Process elevation failed" + (String)errorSuffix;
            default -> "Process returned exit code " + exitCode + (String)errorSuffix;
        };
        return new ProcessOutputException(message, exitCode, combinedError);
    }

    public boolean isIrregularExit() {
        return this.exitCode == 161L || this.exitCode == 162L || this.exitCode == 160L || this.exitCode == 163L || this.exitCode == 164L;
    }

    public boolean isKill() {
        return this.exitCode == 162L;
    }

    public long getExitCode() {
        return this.exitCode;
    }

    public String getOutput() {
        return this.output;
    }
}

