/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.CommandBuilder;
import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.process.ShellDialect;
import io.xpipe.core.process.ShellOpenFunction;
import java.util.ServiceLoader;
import lombok.NonNull;

public abstract class ProcessControlProvider {
    private static ProcessControlProvider INSTANCE;

    public static void init(ModuleLayer layer) {
        INSTANCE = ServiceLoader.load(layer, ProcessControlProvider.class).stream().map(localProcessControlProviderProvider -> (ProcessControlProvider)localProcessControlProviderProvider.get()).findFirst().orElseThrow();
    }

    public static ProcessControlProvider get() {
        return INSTANCE;
    }

    public abstract ShellControl withDefaultScripts(ShellControl var1);

    public abstract ShellControl sub(ShellControl var1, @NonNull ShellOpenFunction var2, ShellOpenFunction var3);

    public abstract CommandControl command(ShellControl var1, CommandBuilder var2, CommandBuilder var3);

    public abstract ShellControl createLocalProcessControl(boolean var1);

    public abstract Object getGitStorageHandler();

    public abstract ShellDialect getEffectiveLocalDialect();

    public abstract void toggleFallbackShell();

    public abstract ShellDialect getDefaultLocalDialect();

    public abstract ShellDialect getFallbackDialect();
}

