/*
 * Decompiled with CFR 0.152.
 */
package io.xpipe.core.process;

import io.xpipe.core.process.CommandControl;
import io.xpipe.core.process.PropertiesFormatsParser;
import io.xpipe.core.process.ShellControl;
import io.xpipe.core.store.FileNames;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public interface OsType {
    public static final Windows WINDOWS = new Windows();
    public static final Linux LINUX = new Linux();
    public static final MacOs MACOS = new MacOs();
    public static final Bsd BSD = new Bsd();
    public static final Solaris SOLARIS = new Solaris();

    public static Local getLocal() {
        String osName = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (osName.contains("mac") || osName.contains("darwin")) {
            return MACOS;
        }
        if (osName.contains("win")) {
            return WINDOWS;
        }
        if (osName.contains("nux")) {
            return LINUX;
        }
        throw new UnsupportedOperationException("Unknown operating system");
    }

    public String makeFileSystemCompatible(String var1);

    public List<String> determineInterestingPaths(ShellControl var1) throws Exception;

    public String getHomeDirectory(ShellControl var1) throws Exception;

    public String getFileSystemSeparator();

    public String getName();

    public String getTempDirectory(ShellControl var1) throws Exception;

    public Map<String, String> getProperties(ShellControl var1) throws Exception;

    public String determineOperatingSystemName(ShellControl var1) throws Exception;

    public static final class MacOs
    implements OsType,
    Local,
    Any {
        @Override
        public String getId() {
            return "macos";
        }

        @Override
        public String makeFileSystemCompatible(String name) {
            return name.replaceAll("[\\\\/:]", "_").replaceAll("\u0000", "");
        }

        @Override
        public List<String> determineInterestingPaths(ShellControl pc) throws Exception {
            String home = this.getHomeDirectory(pc);
            return List.of(home, FileNames.join(home, "Downloads"), FileNames.join(home, "Documents"), FileNames.join(home, "Desktop"), "/Applications", "/Library", "/System", "/etc");
        }

        @Override
        public String getHomeDirectory(ShellControl pc) throws Exception {
            return pc.executeSimpleStringCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("HOME"));
        }

        @Override
        public String getFileSystemSeparator() {
            return "/";
        }

        @Override
        public String getName() {
            return "Mac";
        }

        @Override
        public String getTempDirectory(ShellControl pc) throws Exception {
            String found = pc.executeSimpleStringCommand(pc.getShellDialect().getPrintVariableCommand("TMPDIR"));
            if (found.isBlank()) {
                return "/tmp";
            }
            return found;
        }

        @Override
        public Map<String, String> getProperties(ShellControl pc) throws Exception {
            try (CommandControl c = pc.command("sw_vers").start();){
                String text = c.readStdoutOrThrow();
                Map<String, String> map = PropertiesFormatsParser.parse(text, ":");
                return map;
            }
        }

        @Override
        public String determineOperatingSystemName(ShellControl pc) throws Exception {
            Map<String, String> properties = this.getProperties(pc);
            String name = pc.executeSimpleStringCommand("awk '/SOFTWARE LICENSE AGREEMENT FOR macOS/' '/System/Library/CoreServices/Setup Assistant.app/Contents/Resources/en.lproj/OSXSoftwareLicense.rtf' | awk -F 'macOS ' '{print $NF}' | awk '{print substr($0, 0, length($0)-1)}'");
            if (name.isBlank()) {
                name = "?";
            }
            return properties.get("ProductName") + " " + name + " " + properties.get("ProductVersion");
        }
    }

    public static final class Windows
    implements OsType,
    Local,
    Any {
        @Override
        public String makeFileSystemCompatible(String name) {
            return name.replaceAll("[<>:\"/\\\\|?*]", "_").replaceAll("\\p{C}", "");
        }

        @Override
        public List<String> determineInterestingPaths(ShellControl pc) throws Exception {
            String home = this.getHomeDirectory(pc);
            return List.of(home, FileNames.join(home, "Documents"), FileNames.join(home, "Downloads"), FileNames.join(home, "Desktop"));
        }

        @Override
        public String getHomeDirectory(ShellControl pc) throws Exception {
            return pc.executeSimpleStringCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("USERPROFILE"));
        }

        @Override
        public String getFileSystemSeparator() {
            return "\\";
        }

        @Override
        public String getName() {
            return "Windows";
        }

        @Override
        public String getTempDirectory(ShellControl pc) throws Exception {
            String def = pc.executeSimpleStringCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("TEMP"));
            if (!def.isBlank() && pc.getShellDialect().directoryExists(pc, def).executeAndCheck()) {
                return def;
            }
            String fallback = pc.executeSimpleStringCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("LOCALAPPDATA"));
            if (!fallback.isBlank() && pc.getShellDialect().directoryExists(pc, fallback).executeAndCheck()) {
                return fallback;
            }
            return def;
        }

        @Override
        public Map<String, String> getProperties(ShellControl pc) throws Exception {
            try (CommandControl c = pc.command("systeminfo").start();){
                String text = c.readStdoutOrThrow();
                Map<String, String> map = PropertiesFormatsParser.parse(text, ":");
                return map;
            }
        }

        @Override
        public String determineOperatingSystemName(ShellControl pc) {
            try {
                return pc.executeSimpleStringCommand("wmic os get Caption").lines().skip(1L).collect(Collectors.joining()).trim() + " " + pc.executeSimpleStringCommand("wmic os get Version").lines().skip(1L).collect(Collectors.joining()).trim();
            }
            catch (Throwable t) {
                return "Windows";
            }
        }

        @Override
        public String getId() {
            return "windows";
        }
    }

    public static final class Linux
    extends Unix
    implements OsType,
    Local,
    Any {
        @Override
        public String getId() {
            return "linux";
        }

        @Override
        public String determineOperatingSystemName(ShellControl pc) throws Exception {
            String text;
            try (CommandControl c = pc.command("lsb_release -a").start();){
                text = c.readStdoutDiscardErr();
                if (c.getExitCode() == 0L) {
                    String string = PropertiesFormatsParser.parse(text, ":").getOrDefault("Description", "Unknown");
                    return string;
                }
            }
            c = pc.command("cat /etc/*release").start();
            try {
                text = c.readStdoutDiscardErr();
                if (c.getExitCode() == 0L) {
                    String string = PropertiesFormatsParser.parse(text, "=").getOrDefault("PRETTY_NAME", "Unknown");
                    return string;
                }
            }
            finally {
                if (c != null) {
                    c.close();
                }
            }
            return super.determineOperatingSystemName(pc);
        }
    }

    public static final class Bsd
    extends Unix
    implements Any {
    }

    public static final class Solaris
    extends Unix
    implements Any {
    }

    public static class Unix
    implements OsType {
        @Override
        public String makeFileSystemCompatible(String name) {
            return name.replaceAll("/\\\\", "_").replaceAll("\u0000", "");
        }

        @Override
        public List<String> determineInterestingPaths(ShellControl pc) throws Exception {
            String home = this.getHomeDirectory(pc);
            return List.of(home, FileNames.join(home, "Downloads"), FileNames.join(home, "Documents"), "/etc", "/tmp", "/var");
        }

        @Override
        public String getHomeDirectory(ShellControl pc) throws Exception {
            return pc.executeSimpleStringCommand(pc.getShellDialect().getPrintEnvironmentVariableCommand("HOME"));
        }

        @Override
        public String getFileSystemSeparator() {
            return "/";
        }

        @Override
        public String getName() {
            return "Linux";
        }

        @Override
        public String getTempDirectory(ShellControl pc) {
            return "/tmp/";
        }

        @Override
        public Map<String, String> getProperties(ShellControl pc) {
            return null;
        }

        @Override
        public String determineOperatingSystemName(ShellControl pc) throws Exception {
            String type = "Unknown";
            try (CommandControl c = pc.command("uname -o").start();){
                String text = c.readStdoutDiscardErr();
                if (c.getExitCode() == 0L) {
                    type = text.strip();
                }
            }
            String version = "?";
            try (CommandControl c = pc.command("uname -r").start();){
                String text = c.readStdoutDiscardErr();
                if (c.getExitCode() == 0L) {
                    version = text.strip();
                }
            }
            return type + " " + version;
        }
    }

    public static sealed interface Any
    extends OsType
    permits Windows, Linux, MacOs, Solaris, Bsd {
    }

    public static sealed interface Local
    extends OsType
    permits Windows, Linux, MacOs {
        public String getId();

        default public Any toAny() {
            return (Any)((Object)this);
        }
    }
}

